/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.JsonRepositories;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHUser {
    GitHub root;
    private String gravatar_id;
    private String name;
    private String company;
    private String location;
    private String created_at;
    private String blog;
    private String login;
    private String email;
    private int public_gist_count;
    private int public_repo_count;
    private int following_count;
    private int id;
    private int followers_count;
    private transient Map<String, GHRepository> repositories;

    public String getGravatarId() {
        return this.gravatar_id;
    }

    public String getName() {
        return this.name;
    }

    public String getCompany() {
        return this.company;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCreatedAt() {
        return this.created_at;
    }

    public String getBlog() {
        return this.blog;
    }

    public String getLogin() {
        return this.login;
    }

    public String getEmail() {
        return this.email;
    }

    public int getPublicGistCount() {
        return this.public_gist_count;
    }

    public int getPublicRepoCount() {
        return this.public_repo_count;
    }

    public int getFollowingCount() {
        return this.following_count;
    }

    public int getId() {
        return this.id;
    }

    public int getFollowersCount() {
        return this.followers_count;
    }

    public Map<String, GHRepository> getRepositories() throws IOException {
        if (this.repositories == null) {
            this.repositories = new TreeMap<String, GHRepository>();
            URL url = new URL("http://github.com/api/v2/json/repos/show/" + this.login);
            for (GHRepository r : ((JsonRepositories)GitHub.MAPPER.readValue((URL)url, JsonRepositories.class)).repositories) {
                r.root = this.root;
                this.repositories.put(r.getName(), r);
            }
        }
        return Collections.unmodifiableMap(this.repositories);
    }

    public GHRepository getRepository(String name) throws IOException {
        return this.getRepositories().get(name);
    }

    public String toString() {
        return "User:" + this.login;
    }

    public int hashCode() {
        return this.login.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GHUser) {
            GHUser that = (GHUser)obj;
            return this.login.equals(that.login);
        }
        return false;
    }
}

