/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.JsonIssueComments;
import org.kohsuke.github.Poster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHIssue {
    GitHub root;
    GHRepository owner;
    private String gravatar_id;
    private String body;
    private String title;
    private String state;
    private String created_at;
    private String updated_at;
    private String html_url;
    private List<String> labels;
    private int number;
    private int votes;
    private int comments;
    private int position;

    public GHRepository getRepository() {
        return this.owner;
    }

    public String getBody() {
        return this.body;
    }

    public int getNumber() {
        return this.number;
    }

    public URL getUrl() {
        return GitHub.parseURL(this.html_url);
    }

    public String getTitle() {
        return this.title;
    }

    public GHIssueState getState() {
        return Enum.valueOf(GHIssueState.class, this.state);
    }

    public Collection<String> getLabels() {
        return Collections.unmodifiableList(this.labels);
    }

    public Date getCreatedAt() {
        return GitHub.parseDate(this.created_at);
    }

    public Date getUpdatedAt() {
        return GitHub.parseDate(this.updated_at);
    }

    public void comment(String message) throws IOException {
        new Poster(this.root).withCredential().with("comment", message).to(this.getApiRoute("comment"));
    }

    public void close() throws IOException {
        new Poster(this.root).withCredential().to(this.getApiRoute("close"));
    }

    public void reopen() throws IOException {
        new Poster(this.root).withCredential().to(this.getApiRoute("reopen"));
    }

    public List<GHIssueComment> getComments() throws IOException {
        return this.root.retrieve(this.getApiRoute("comments"), JsonIssueComments.class).wrap(this);
    }

    private String getApiRoute(String verb) {
        return "/issues/" + verb + "/" + this.owner.getOwnerName() + "/" + this.owner.getName() + "/" + this.number;
    }
}

