/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.List;
import org.kohsuke.github.GHDeployment;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.Requester;

public class GHDeploymentBuilder {
    private final GHRepository repo;
    private final Requester builder;

    public GHDeploymentBuilder(GHRepository repo) {
        this.repo = repo;
        this.builder = new Requester(repo.root);
    }

    public GHDeploymentBuilder(GHRepository repo, String ref) {
        this(repo);
        this.ref(ref);
    }

    public GHDeploymentBuilder ref(String branch) {
        this.builder.with("ref", branch);
        return this;
    }

    public GHDeploymentBuilder task(String task) {
        this.builder.with("task", task);
        return this;
    }

    public GHDeploymentBuilder autoMerge(boolean autoMerge) {
        this.builder.with("auto_merge", autoMerge);
        return this;
    }

    public GHDeploymentBuilder requiredContexts(List<String> requiredContexts) {
        this.builder.with("required_contexts", requiredContexts);
        return this;
    }

    public GHDeploymentBuilder payload(String payload) {
        this.builder.with("payload", payload);
        return this;
    }

    public GHDeploymentBuilder environment(String environment) {
        this.builder.with("environment", environment);
        return this;
    }

    public GHDeploymentBuilder description(String description) {
        this.builder.with("description", description);
        return this;
    }

    public GHDeployment create() throws IOException {
        return ((GHDeployment)((Object)this.builder.to(this.repo.getApiTailUrl("deployments"), GHDeployment.class))).wrap(this.repo);
    }
}

