/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonSetter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import org.kohsuke.github.GHCommitComment;
import org.kohsuke.github.GHDeployment;
import org.kohsuke.github.GHDeploymentStatus;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestReview;
import org.kohsuke.github.GHPullRequestReviewComment;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitUser;

public abstract class GHEventPayload {
    protected GitHub root;
    private GHUser sender;

    GHEventPayload() {
    }

    public GHUser getSender() {
        return this.sender;
    }

    public void setSender(GHUser sender) {
        this.sender = sender;
    }

    void wrapUp(GitHub root) {
        this.root = root;
        if (this.sender != null) {
            this.sender.wrapUp(root);
        }
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR", "NP_UNWRITTEN_FIELD", "UWF_UNWRITTEN_FIELD"}, justification="Constructed by JSON deserialization")
    public static class Repository
    extends GHEventPayload {
        private String action;
        private GHRepository repository;
        private GHOrganization organization;

        public String getAction() {
            return this.action;
        }

        public void setRepository(GHRepository repository) {
            this.repository = repository;
        }

        public GHRepository getRepository() {
            return this.repository;
        }

        public GHOrganization getOrganization() {
            return this.organization;
        }

        public void setOrganization(GHOrganization organization) {
            this.organization = organization;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            this.repository.wrap(root);
            if (this.organization != null) {
                this.organization.wrapUp(root);
            }
        }
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR", "NP_UNWRITTEN_FIELD"}, justification="Constructed by JSON deserialization")
    public static class Release
    extends GHEventPayload {
        private String action;
        private GHRelease release;
        private GHRepository repository;

        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Comes from JSON deserialization")
        public String getAction() {
            return this.action;
        }

        public GHRelease getRelease() {
            return this.release;
        }

        public void setRelease(GHRelease release) {
            this.release = release;
        }

        public GHRepository getRepository() {
            return this.repository;
        }

        public void setRepository(GHRepository repository) {
            this.repository = repository;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.repository != null) {
                this.repository.wrap(root);
            }
        }
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR", "NP_UNWRITTEN_FIELD", "UUF_UNUSED_FIELD"}, justification="Constructed by JSON deserialization")
    public static class Push
    extends GHEventPayload {
        private String head;
        private String before;
        private boolean created;
        private boolean deleted;
        private boolean forced;
        private String ref;
        private int size;
        private List<PushCommit> commits;
        private GHRepository repository;
        private Pusher pusher;

        public String getHead() {
            return this.head;
        }

        public String getBefore() {
            return this.before;
        }

        @JsonSetter
        private void setAfter(String after) {
            this.head = after;
        }

        public String getRef() {
            return this.ref;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isCreated() {
            return this.created;
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public boolean isForced() {
            return this.forced;
        }

        public List<PushCommit> getCommits() {
            return this.commits;
        }

        public GHRepository getRepository() {
            return this.repository;
        }

        public Pusher getPusher() {
            return this.pusher;
        }

        public void setPusher(Pusher pusher) {
            this.pusher = pusher;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.repository != null) {
                this.repository.wrap(root);
            }
        }

        public static class PushCommit {
            private GitUser author;
            private GitUser committer;
            private String url;
            private String sha;
            private String message;
            private boolean distinct;
            private List<String> added;
            private List<String> removed;
            private List<String> modified;

            public GitUser getAuthor() {
                return this.author;
            }

            public GitUser getCommitter() {
                return this.committer;
            }

            public String getUrl() {
                return this.url;
            }

            public String getSha() {
                return this.sha;
            }

            @JsonSetter
            private void setId(String id) {
                this.sha = id;
            }

            public String getMessage() {
                return this.message;
            }

            public boolean isDistinct() {
                return this.distinct;
            }

            public List<String> getAdded() {
                return this.added;
            }

            public List<String> getRemoved() {
                return this.removed;
            }

            public List<String> getModified() {
                return this.modified;
            }
        }

        public static class Pusher {
            private String name;
            private String email;

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getEmail() {
                return this.email;
            }

            public void setEmail(String email) {
                this.email = email;
            }
        }
    }

    public static class Public
    extends GHEventPayload {
        private GHRepository repository;

        public void setRepository(GHRepository repository) {
            this.repository = repository;
        }

        public GHRepository getRepository() {
            return this.repository;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.repository != null) {
                this.repository.wrap(root);
            }
        }
    }

    public static class Ping
    extends GHEventPayload {
        private GHRepository repository;
        private GHOrganization organization;

        public void setRepository(GHRepository repository) {
            this.repository = repository;
        }

        public GHRepository getRepository() {
            return this.repository;
        }

        public GHOrganization getOrganization() {
            return this.organization;
        }

        public void setOrganization(GHOrganization organization) {
            this.organization = organization;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.repository != null) {
                this.repository.wrap(root);
            }
            if (this.organization != null) {
                this.organization.wrapUp(root);
            }
        }
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR", "NP_UNWRITTEN_FIELD"}, justification="Constructed by JSON deserialization")
    public static class Fork
    extends GHEventPayload {
        private GHRepository forkee;
        private GHRepository repository;

        public GHRepository getForkee() {
            return this.forkee;
        }

        public void setForkee(GHRepository forkee) {
            this.forkee = forkee;
        }

        public GHRepository getRepository() {
            return this.repository;
        }

        public void setRepository(GHRepository repository) {
            this.repository = repository;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            this.forkee.wrap(root);
            if (this.repository != null) {
                this.repository.wrap(root);
            }
        }
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR", "NP_UNWRITTEN_FIELD"}, justification="Constructed by JSON deserialization")
    public static class DeploymentStatus
    extends GHEventPayload {
        private GHDeploymentStatus deploymentStatus;
        private GHDeployment deployment;
        private GHRepository repository;

        public GHDeploymentStatus getDeploymentStatus() {
            return this.deploymentStatus;
        }

        public void setDeploymentStatus(GHDeploymentStatus deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        public GHDeployment getDeployment() {
            return this.deployment;
        }

        public void setDeployment(GHDeployment deployment) {
            this.deployment = deployment;
        }

        public GHRepository getRepository() {
            return this.repository;
        }

        public void setRepository(GHRepository repository) {
            this.repository = repository;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.repository != null) {
                this.repository.wrap(root);
                this.deployment.wrap(this.repository);
                this.deploymentStatus.wrap(this.repository);
            }
        }
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR", "NP_UNWRITTEN_FIELD"}, justification="Constructed by JSON deserialization")
    public static class Deployment
    extends GHEventPayload {
        private GHDeployment deployment;
        private GHRepository repository;

        public GHDeployment getDeployment() {
            return this.deployment;
        }

        public void setDeployment(GHDeployment deployment) {
            this.deployment = deployment;
        }

        public GHRepository getRepository() {
            return this.repository;
        }

        public void setRepository(GHRepository repository) {
            this.repository = repository;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.repository != null) {
                this.repository.wrap(root);
                this.deployment.wrap(this.repository);
            }
        }
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR", "NP_UNWRITTEN_FIELD"}, justification="Constructed by JSON deserialization")
    public static class Delete
    extends GHEventPayload {
        private String ref;
        private String refType;
        private GHRepository repository;

        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Comes from JSON deserialization")
        public String getRef() {
            return this.ref;
        }

        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Comes from JSON deserialization")
        public String getRefType() {
            return this.refType;
        }

        public GHRepository getRepository() {
            return this.repository;
        }

        public void setRepository(GHRepository repository) {
            this.repository = repository;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.repository != null) {
                this.repository.wrap(root);
            }
        }
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR", "NP_UNWRITTEN_FIELD"}, justification="Constructed by JSON deserialization")
    public static class Create
    extends GHEventPayload {
        private String ref;
        private String refType;
        private String masterBranch;
        private String description;
        private GHRepository repository;

        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Comes from JSON deserialization")
        public String getRef() {
            return this.ref;
        }

        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Comes from JSON deserialization")
        public String getRefType() {
            return this.refType;
        }

        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Comes from JSON deserialization")
        public String getMasterBranch() {
            return this.masterBranch;
        }

        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Comes from JSON deserialization")
        public String getDescription() {
            return this.description;
        }

        public GHRepository getRepository() {
            return this.repository;
        }

        public void setRepository(GHRepository repository) {
            this.repository = repository;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.repository != null) {
                this.repository.wrap(root);
            }
        }
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR", "NP_UNWRITTEN_FIELD"}, justification="Constructed by JSON deserialization")
    public static class CommitComment
    extends GHEventPayload {
        private String action;
        private GHCommitComment comment;
        private GHRepository repository;

        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Comes from JSON deserialization")
        public String getAction() {
            return this.action;
        }

        public GHCommitComment getComment() {
            return this.comment;
        }

        public void setComment(GHCommitComment comment) {
            this.comment = comment;
        }

        public GHRepository getRepository() {
            return this.repository;
        }

        public void setRepository(GHRepository repository) {
            this.repository = repository;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.repository != null) {
                this.repository.wrap(root);
                this.comment.wrap(this.repository);
            }
        }
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR", "NP_UNWRITTEN_FIELD"}, justification="Constructed by JSON deserialization")
    public static class IssueComment
    extends GHEventPayload {
        private String action;
        private GHIssueComment comment;
        private GHIssue issue;
        private GHRepository repository;

        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Comes from JSON deserialization")
        public String getAction() {
            return this.action;
        }

        public GHIssueComment getComment() {
            return this.comment;
        }

        public void setComment(GHIssueComment comment) {
            this.comment = comment;
        }

        public GHIssue getIssue() {
            return this.issue;
        }

        public void setIssue(GHIssue issue) {
            this.issue = issue;
        }

        public GHRepository getRepository() {
            return this.repository;
        }

        public void setRepository(GHRepository repository) {
            this.repository = repository;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.repository != null) {
                this.repository.wrap(root);
                this.issue.wrap(this.repository);
            } else {
                this.issue.wrap(root);
            }
            this.comment.wrapUp(this.issue);
        }
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR", "NP_UNWRITTEN_FIELD"}, justification="Constructed by JSON deserialization")
    public static class Issue
    extends GHEventPayload {
        private String action;
        private GHIssue issue;
        private GHRepository repository;

        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Comes from JSON deserialization")
        public String getAction() {
            return this.action;
        }

        public GHIssue getIssue() {
            return this.issue;
        }

        public void setIssue(GHIssue issue) {
            this.issue = issue;
        }

        public GHRepository getRepository() {
            return this.repository;
        }

        public void setRepository(GHRepository repository) {
            this.repository = repository;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.repository != null) {
                this.repository.wrap(root);
                this.issue.wrap(this.repository);
            } else {
                this.issue.wrap(root);
            }
        }
    }

    public static class PullRequestReviewComment
    extends GHEventPayload {
        private String action;
        private GHPullRequestReviewComment comment;
        private GHPullRequest pull_request;
        private GHRepository repository;

        public String getAction() {
            return this.action;
        }

        public GHPullRequestReviewComment getComment() {
            return this.comment;
        }

        public GHPullRequest getPullRequest() {
            return this.pull_request;
        }

        public GHRepository getRepository() {
            return this.repository;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.comment == null) {
                throw new IllegalStateException("Expected pull_request_review_comment payload, but got something else. Maybe we've got another type of event?");
            }
            this.comment.wrapUp(this.pull_request);
            if (this.repository != null) {
                this.repository.wrap(root);
                this.pull_request.wrapUp(this.repository);
            } else {
                this.pull_request.wrapUp(root);
            }
        }
    }

    public static class PullRequestReview
    extends GHEventPayload {
        private String action;
        private GHPullRequestReview review;
        private GHPullRequest pull_request;
        private GHRepository repository;

        public String getAction() {
            return this.action;
        }

        public GHPullRequestReview getReview() {
            return this.review;
        }

        public GHPullRequest getPullRequest() {
            return this.pull_request;
        }

        public GHRepository getRepository() {
            return this.repository;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.review == null) {
                throw new IllegalStateException("Expected pull_request_review payload, but got something else. Maybe we've got another type of event?");
            }
            this.review.wrapUp(this.pull_request);
            if (this.repository != null) {
                this.repository.wrap(root);
                this.pull_request.wrapUp(this.repository);
            } else {
                this.pull_request.wrapUp(root);
            }
        }
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"}, justification="JSON API")
    public static class PullRequest
    extends GHEventPayload {
        private String action;
        private int number;
        private GHPullRequest pull_request;
        private GHRepository repository;

        public String getAction() {
            return this.action;
        }

        public int getNumber() {
            return this.number;
        }

        public GHPullRequest getPullRequest() {
            this.pull_request.root = this.root;
            return this.pull_request;
        }

        public GHRepository getRepository() {
            return this.repository;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.pull_request == null) {
                throw new IllegalStateException("Expected pull_request payload, but got something else. Maybe we've got another type of event?");
            }
            if (this.repository != null) {
                this.repository.wrap(root);
                this.pull_request.wrapUp(this.repository);
            } else {
                this.pull_request.wrapUp(root);
            }
        }
    }
}

