/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import org.kohsuke.github.GHCommentAuthorAssociation;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHReaction;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Reactable;
import org.kohsuke.github.ReactionContent;
import org.kohsuke.github.Requester;

public class GHIssueComment
extends GHObject
implements Reactable {
    GHIssue owner;
    private String body;
    private String gravatar_id;
    private String html_url;
    private String author_association;
    private GHUser user;

    GHIssueComment wrapUp(GHIssue owner) {
        this.owner = owner;
        return this;
    }

    public GHIssue getParent() {
        return this.owner;
    }

    public String getBody() {
        return this.body;
    }

    @Deprecated
    public String getUserName() {
        return this.user.getLogin();
    }

    public GHUser getUser() throws IOException {
        return this.owner == null || this.owner.root.isOffline() ? this.user : this.owner.root.getUser(this.user.getLogin());
    }

    @Override
    public URL getHtmlUrl() {
        return GitHub.parseURL(this.html_url);
    }

    public GHCommentAuthorAssociation getAuthorAssociation() {
        return GHCommentAuthorAssociation.valueOf(this.author_association);
    }

    public void update(String body) throws IOException {
        new Requester(this.owner.root).with("body", body).method("PATCH").to(this.getApiRoute(), GHIssueComment.class);
        this.body = body;
    }

    public void delete() throws IOException {
        new Requester(this.owner.root).method("DELETE").to(this.getApiRoute());
    }

    @Override
    @Preview
    @Deprecated
    public GHReaction createReaction(ReactionContent content) throws IOException {
        return ((GHReaction)((Object)new Requester(this.owner.root).withPreview("application/vnd.github.squirrel-girl-preview").with("content", content.getContent()).to(this.getApiRoute() + "/reactions", GHReaction.class))).wrap(this.owner.root);
    }

    @Override
    @Preview
    @Deprecated
    public PagedIterable<GHReaction> listReactions() {
        return this.owner.root.retrieve().withPreview("application/vnd.github.squirrel-girl-preview").asPagedIterable(this.getApiRoute() + "/reactions", GHReaction[].class, item -> item.wrap(this.owner.root));
    }

    private String getApiRoute() {
        return "/repos/" + this.owner.getRepository().getOwnerName() + "/" + this.owner.getRepository().getName() + "/issues/comments/" + this.id;
    }
}

