/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Locale;
import org.kohsuke.github.GHMilestoneState;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Requester;

public class GHMilestone
extends GHObject {
    GitHub root;
    GHRepository owner;
    GHUser creator;
    private String state;
    private String due_on;
    private String title;
    private String description;
    private String html_url;
    private int closed_issues;
    private int open_issues;
    private int number;
    protected String closed_at;

    public GitHub getRoot() {
        return this.root;
    }

    public GHRepository getOwner() {
        return this.owner;
    }

    public GHUser getCreator() throws IOException {
        return this.root.intern(this.creator);
    }

    public Date getDueOn() {
        if (this.due_on == null) {
            return null;
        }
        return GitHub.parseDate(this.due_on);
    }

    public Date getClosedAt() throws IOException {
        return GitHub.parseDate(this.closed_at);
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public int getClosedIssues() {
        return this.closed_issues;
    }

    public int getOpenIssues() {
        return this.open_issues;
    }

    public int getNumber() {
        return this.number;
    }

    @Override
    public URL getHtmlUrl() {
        return GitHub.parseURL(this.html_url);
    }

    public GHMilestoneState getState() {
        return Enum.valueOf(GHMilestoneState.class, this.state.toUpperCase(Locale.ENGLISH));
    }

    public void close() throws IOException {
        this.edit("state", "closed");
    }

    public void reopen() throws IOException {
        this.edit("state", "open");
    }

    public void delete() throws IOException {
        this.root.retrieve().method("DELETE").to(this.getApiRoute());
    }

    private void edit(String key, Object value) throws IOException {
        new Requester(this.root).with(key, value).method("PATCH").to(this.getApiRoute());
    }

    public void setTitle(String title) throws IOException {
        this.edit("title", title);
    }

    public void setDescription(String description) throws IOException {
        this.edit("description", description);
    }

    public void setDueOn(Date dueOn) throws IOException {
        this.edit("due_on", GitHub.printDate(dueOn));
    }

    protected String getApiRoute() {
        return "/repos/" + this.owner.getOwnerName() + "/" + this.owner.getName() + "/milestones/" + this.number;
    }

    public GHMilestone wrap(GHRepository repo) {
        this.owner = repo;
        this.root = repo.root;
        return this;
    }
}

