/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import org.kohsuke.github.GHDeploymentState;
import org.kohsuke.github.GHDeploymentStatus;
import org.kohsuke.github.GHDeploymentStatusBuilder;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;

public class GHDeployment
extends GHObject {
    private GHRepository owner;
    private GitHub root;
    protected String sha;
    protected String ref;
    protected String task;
    protected Object payload;
    protected String environment;
    protected String description;
    protected String statuses_url;
    protected String repository_url;
    protected GHUser creator;

    GHDeployment wrap(GHRepository owner) {
        this.owner = owner;
        this.root = owner.root;
        if (this.creator != null) {
            this.creator.wrapUp(this.root);
        }
        return this;
    }

    public URL getStatusesUrl() {
        return GitHub.parseURL(this.statuses_url);
    }

    public URL getRepositoryUrl() {
        return GitHub.parseURL(this.repository_url);
    }

    public String getTask() {
        return this.task;
    }

    public String getPayload() {
        return (String)this.payload;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public GHUser getCreator() throws IOException {
        return this.root.intern(this.creator);
    }

    public String getRef() {
        return this.ref;
    }

    public String getSha() {
        return this.sha;
    }

    @Override
    public URL getHtmlUrl() {
        return null;
    }

    public GHDeploymentStatusBuilder createStatus(GHDeploymentState state) {
        return new GHDeploymentStatusBuilder(this.owner, this.id, state);
    }

    public PagedIterable<GHDeploymentStatus> listStatuses() {
        return this.root.createRequest().withUrlPath(this.statuses_url).toIterable(GHDeploymentStatus[].class, item -> item.wrap(this.owner));
    }
}

