/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.Requester;

public class GHReleaseUpdater {
    private final GHRelease base;
    private final Requester builder;

    GHReleaseUpdater(GHRelease base) {
        this.base = base;
        this.builder = base.root.createRequest();
    }

    public GHReleaseUpdater tag(String tag) {
        this.builder.with("tag_name", tag);
        return this;
    }

    public GHReleaseUpdater body(String body) {
        this.builder.with("body", body);
        return this;
    }

    public GHReleaseUpdater commitish(String commitish) {
        this.builder.with("target_commitish", commitish);
        return this;
    }

    public GHReleaseUpdater draft(boolean draft) {
        this.builder.with("draft", draft);
        return this;
    }

    public GHReleaseUpdater name(String name) {
        this.builder.with("name", name);
        return this;
    }

    public GHReleaseUpdater prerelease(boolean prerelease) {
        this.builder.with("prerelease", prerelease);
        return this;
    }

    public GHRelease update() throws IOException {
        return this.builder.method("PATCH").withUrlPath(this.base.owner.getApiTailUrl("releases/" + this.base.id)).fetch(GHRelease.class).wrap(this.base.owner);
    }
}

