/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import org.kohsuke.github.GitHub;

public class GHRef {
    GitHub root;
    private String ref;
    private String url;
    private GHObject object;

    public String getRef() {
        return this.ref;
    }

    public URL getUrl() {
        return GitHub.parseURL(this.url);
    }

    public GHObject getObject() {
        return this.object;
    }

    public void updateTo(String sha) throws IOException {
        this.updateTo(sha, false);
    }

    public void updateTo(String sha, Boolean force) throws IOException {
        this.root.createRequest().method("PATCH").with("sha", sha).with("force", force).withUrlPath(this.url).fetch(GHRef.class).wrap(this.root);
    }

    public void delete() throws IOException {
        this.root.createRequest().method("DELETE").withUrlPath(this.url).send();
    }

    GHRef wrap(GitHub root) {
        this.root = root;
        return this;
    }

    static GHRef[] wrap(GHRef[] in, GitHub root) {
        for (GHRef r : in) {
            r.wrap(root);
        }
        return in;
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"}, justification="JSON API")
    public static class GHObject {
        private String type;
        private String sha;
        private String url;

        public String getType() {
            return this.type;
        }

        public String getSha() {
            return this.sha;
        }

        public URL getUrl() {
            return GitHub.parseURL(this.url);
        }
    }
}

