/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hidden.com.fasterxml.jackson.annotation.JsonInclude;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTree;
import org.kohsuke.github.Requester;

public class GHTreeBuilder {
    private final GHRepository repo;
    private final Requester req;
    private final List<TreeEntry> treeEntries = new ArrayList<TreeEntry>();

    GHTreeBuilder(GHRepository repo) {
        this.repo = repo;
        this.req = repo.root.createRequest();
    }

    public GHTreeBuilder baseTree(String baseTree) {
        this.req.with("base_tree", baseTree);
        return this;
    }

    @Deprecated
    public GHTreeBuilder entry(String path, String mode, String type, String sha, String content) {
        TreeEntry entry = new TreeEntry(path, mode, type);
        entry.sha = sha;
        entry.content = content;
        this.treeEntries.add(entry);
        return this;
    }

    @Deprecated
    public GHTreeBuilder shaEntry(String path, String sha, boolean executable) {
        TreeEntry entry = new TreeEntry(path, executable ? "100755" : "100644", "blob");
        entry.sha = sha;
        this.treeEntries.add(entry);
        return this;
    }

    @Deprecated
    public GHTreeBuilder textEntry(String path, String content, boolean executable) {
        TreeEntry entry = new TreeEntry(path, executable ? "100755" : "100644", "blob");
        entry.content = content;
        this.treeEntries.add(entry);
        return this;
    }

    public GHTreeBuilder add(String path, byte[] content, boolean executable) {
        try {
            String dataSha = this.repo.createBlob().binaryContent(content).create().getSha();
            return this.shaEntry(path, dataSha, executable);
        }
        catch (IOException e) {
            throw new GHException("Cannot create binary content of '" + path + "'", e);
        }
    }

    public GHTreeBuilder add(String path, String content, boolean executable) {
        return this.add(path, content.getBytes(StandardCharsets.UTF_8), executable);
    }

    private String getApiTail() {
        return String.format("/repos/%s/%s/git/trees", this.repo.getOwnerName(), this.repo.getName());
    }

    public GHTree create() throws IOException {
        this.req.with("tree", this.treeEntries);
        return this.req.method("POST").withUrlPath(this.getApiTail()).fetch(GHTree.class).wrap(this.repo);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private static final class TreeEntry {
        private final String path;
        private final String mode;
        private final String type;
        private String sha;
        private String content;

        private TreeEntry(String path, String mode, String type) {
            this.path = path;
            this.mode = mode;
            this.type = type;
        }
    }
}

