/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.kohsuke.github.PagedIterator;

public abstract class PagedIterable<T>
implements Iterable<T> {
    private int size = 0;

    public PagedIterable<T> withPageSize(int size) {
        this.size = size;
        return this;
    }

    @Override
    @Nonnull
    public final PagedIterator<T> iterator() {
        return this._iterator(this.size);
    }

    @Nonnull
    public abstract PagedIterator<T> _iterator(int var1);

    public List<T> asList() {
        ArrayList r = new ArrayList();
        Iterator i = this.iterator();
        while (((PagedIterator)i).hasNext()) {
            r.addAll(((PagedIterator)i).nextPage());
        }
        return r;
    }

    public Set<T> asSet() {
        LinkedHashSet r = new LinkedHashSet();
        Iterator i = this.iterator();
        while (((PagedIterator)i).hasNext()) {
            r.addAll(((PagedIterator)i).nextPage());
        }
        return r;
    }
}

