/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import org.kohsuke.github.GHDirection;
import org.kohsuke.github.GHMarketplaceAccountPlan;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

public class GHMarketplaceListAccountBuilder {
    private final GitHub root;
    private final Requester builder;
    private final long planId;

    GHMarketplaceListAccountBuilder(GitHub root, long planId) {
        this.root = root;
        this.builder = root.createRequest();
        this.planId = planId;
    }

    public GHMarketplaceListAccountBuilder sort(Sort sort) {
        this.builder.with("sort", sort);
        return this;
    }

    public GHMarketplaceListAccountBuilder direction(GHDirection direction) {
        this.builder.with("direction", direction);
        return this;
    }

    public PagedIterable<GHMarketplaceAccountPlan> createRequest() throws IOException {
        return this.builder.withUrlPath(String.format("/marketplace_listing/plans/%d/accounts", this.planId)).toIterable(GHMarketplaceAccountPlan[].class, item -> item.wrapUp(this.root));
    }

    public static enum Sort {
        CREATED,
        UPDATED;

    }
}

