/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.Requester;

public class GHLabel {
    private String url;
    private String name;
    private String color;
    private String description;
    private GHRepository repo;

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public String getColor() {
        return this.color;
    }

    public String getDescription() {
        return this.description;
    }

    GHLabel wrapUp(GHRepository repo) {
        this.repo = repo;
        return this;
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.repo.root.createRequest().method("DELETE")).setRawUrlPath(this.url)).send();
    }

    public void setColor(String newColor) throws IOException {
        ((Requester)((Requester)((Requester)((Requester)((Requester)this.repo.root.createRequest().method("PATCH")).with("name", this.name)).with("color", newColor)).with("description", this.description)).setRawUrlPath(this.url)).send();
    }

    public void setDescription(String newDescription) throws IOException {
        ((Requester)((Requester)((Requester)((Requester)((Requester)this.repo.root.createRequest().method("PATCH")).with("name", this.name)).with("color", this.color)).with("description", newDescription)).setRawUrlPath(this.url)).send();
    }

    static Collection<String> toNames(Collection<GHLabel> labels) {
        ArrayList<String> r = new ArrayList<String>();
        for (GHLabel l : labels) {
            r.add(l.getName());
        }
        return r;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GHLabel ghLabel = (GHLabel)o;
        return Objects.equals(this.url, ghLabel.url) && Objects.equals(this.name, ghLabel.name) && Objects.equals(this.color, ghLabel.color) && Objects.equals(this.repo, ghLabel.repo);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.name, this.color, this.repo);
    }
}

