/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Requester;

abstract class AbstractBuilder<R, S> {
    @Nonnull
    private final Class<R> returnType;
    private final boolean commitChangesImmediately;
    @CheckForNull
    private final R baseInstance;
    @Nonnull
    protected final Requester requester;
    protected boolean updateInPlace;

    protected AbstractBuilder(@Nonnull Class<R> finalReturnType, @Nonnull Class<S> intermediateReturnType, @Nonnull GitHub root, @CheckForNull R baseInstance) {
        this.requester = root.createRequest();
        this.returnType = finalReturnType;
        this.commitChangesImmediately = this.returnType.equals(intermediateReturnType);
        if (!this.commitChangesImmediately && !intermediateReturnType.isInstance(this)) {
            throw new IllegalArgumentException("Argument \"intermediateReturnType\": This instance must be castable to intermediateReturnType or finalReturnType must be equal to intermediateReturnType.");
        }
        this.baseInstance = baseInstance;
        this.updateInPlace = false;
    }

    @Nonnull
    @Preview
    @Deprecated
    public R done() throws IOException {
        R result = this.updateInPlace && this.baseInstance != null ? this.requester.fetchInto(this.baseInstance) : this.requester.fetch(this.returnType);
        return result;
    }

    @Nonnull
    @Preview
    @Deprecated
    protected S with(@Nonnull String name, Object value) throws IOException {
        this.requester.with(name, value);
        return this.continueOrDone();
    }

    @Nonnull
    @Preview
    @Deprecated
    protected S continueOrDone() throws IOException {
        if (this.commitChangesImmediately) {
            return (S)this.done();
        }
        return (S)this;
    }
}

