/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHBranchProtection;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.Requester;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD", "URF_UNREAD_FIELD"}, justification="JSON API")
public class GHBranchProtectionBuilder {
    private final GHBranch branch;
    private boolean enforceAdmins;
    private Map<String, Object> prReviews;
    private Restrictions restrictions;
    private StatusChecks statusChecks;

    GHBranchProtectionBuilder(GHBranch branch) {
        this.branch = branch;
    }

    public GHBranchProtectionBuilder addRequiredChecks(Collection<String> checks) {
        this.getStatusChecks().contexts.addAll(checks);
        return this;
    }

    public GHBranchProtectionBuilder addRequiredChecks(String ... checks) {
        this.addRequiredChecks(Arrays.asList(checks));
        return this;
    }

    public GHBranchProtectionBuilder dismissStaleReviews() {
        return this.dismissStaleReviews(true);
    }

    public GHBranchProtectionBuilder dismissStaleReviews(boolean v) {
        this.getPrReviews().put("dismiss_stale_reviews", v);
        return this;
    }

    public GHBranchProtection enable() throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)((Requester)((Requester)this.requester().method("PUT")).withNullable("required_status_checks", this.statusChecks)).withNullable("required_pull_request_reviews", this.prReviews)).withNullable("restrictions", this.restrictions)).withNullable("enforce_admins", this.enforceAdmins)).withUrlPath(this.branch.getProtectionUrl().toString())).fetch(GHBranchProtection.class).wrap(this.branch);
    }

    public GHBranchProtectionBuilder includeAdmins() {
        return this.includeAdmins(true);
    }

    public GHBranchProtectionBuilder includeAdmins(boolean v) {
        this.enforceAdmins = v;
        return this;
    }

    public GHBranchProtectionBuilder requiredReviewers(int v) {
        this.getPrReviews().put("required_approving_review_count", v);
        return this;
    }

    public GHBranchProtectionBuilder requireBranchIsUpToDate() {
        return this.requireBranchIsUpToDate(true);
    }

    public GHBranchProtectionBuilder requireBranchIsUpToDate(boolean v) {
        this.getStatusChecks().strict = v;
        return this;
    }

    public GHBranchProtectionBuilder requireCodeOwnReviews() {
        return this.requireCodeOwnReviews(true);
    }

    public GHBranchProtectionBuilder requireCodeOwnReviews(boolean v) {
        this.getPrReviews().put("require_code_owner_reviews", v);
        return this;
    }

    public GHBranchProtectionBuilder requireReviews() {
        this.getPrReviews();
        return this;
    }

    public GHBranchProtectionBuilder restrictReviewDismissals() {
        this.getPrReviews();
        if (!this.prReviews.containsKey("dismissal_restrictions")) {
            this.prReviews.put("dismissal_restrictions", new Restrictions());
        }
        return this;
    }

    public GHBranchProtectionBuilder restrictPushAccess() {
        this.getRestrictions();
        return this;
    }

    public GHBranchProtectionBuilder teamPushAccess(Collection<GHTeam> teams) {
        for (GHTeam team : teams) {
            this.teamPushAccess(team);
        }
        return this;
    }

    public GHBranchProtectionBuilder teamPushAccess(GHTeam ... teams) {
        for (GHTeam team : teams) {
            this.getRestrictions().teams.add(team.getSlug());
        }
        return this;
    }

    public GHBranchProtectionBuilder teamReviewDismissals(Collection<GHTeam> teams) {
        for (GHTeam team : teams) {
            this.teamReviewDismissals(team);
        }
        return this;
    }

    public GHBranchProtectionBuilder teamReviewDismissals(GHTeam ... teams) {
        for (GHTeam team : teams) {
            this.addReviewRestriction(team.getSlug(), true);
        }
        return this;
    }

    public GHBranchProtectionBuilder userPushAccess(Collection<GHUser> users) {
        for (GHUser user : users) {
            this.userPushAccess(user);
        }
        return this;
    }

    public GHBranchProtectionBuilder userPushAccess(GHUser ... users) {
        for (GHUser user : users) {
            this.getRestrictions().users.add(user.getLogin());
        }
        return this;
    }

    public GHBranchProtectionBuilder userReviewDismissals(Collection<GHUser> users) {
        for (GHUser team : users) {
            this.userReviewDismissals(team);
        }
        return this;
    }

    public GHBranchProtectionBuilder userReviewDismissals(GHUser ... users) {
        for (GHUser user : users) {
            this.addReviewRestriction(user.getLogin(), false);
        }
        return this;
    }

    private void addReviewRestriction(String restriction, boolean isTeam) {
        this.restrictReviewDismissals();
        Restrictions restrictions = (Restrictions)this.prReviews.get("dismissal_restrictions");
        if (isTeam) {
            restrictions.teams.add(restriction);
        } else {
            restrictions.users.add(restriction);
        }
    }

    private Map<String, Object> getPrReviews() {
        if (this.prReviews == null) {
            this.prReviews = new HashMap<String, Object>();
        }
        return this.prReviews;
    }

    private Restrictions getRestrictions() {
        if (this.restrictions == null) {
            this.restrictions = new Restrictions();
        }
        return this.restrictions;
    }

    private StatusChecks getStatusChecks() {
        if (this.statusChecks == null) {
            this.statusChecks = new StatusChecks();
        }
        return this.statusChecks;
    }

    private Requester requester() {
        return (Requester)this.branch.getRoot().createRequest().withPreview("application/vnd.github.luke-cage-preview+json");
    }

    private static class StatusChecks {
        final List<String> contexts = new ArrayList<String>();
        boolean strict;

        private StatusChecks() {
        }
    }

    private static class Restrictions {
        private Set<String> teams = new HashSet<String>();
        private Set<String> users = new HashSet<String>();

        private Restrictions() {
        }
    }
}

