/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.github.GHEmail;
import org.kohsuke.github.GHKey;
import org.kohsuke.github.GHMembership;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHPersonSet;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GHVerifiedKey;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

public class GHMyself
extends GHUser {
    public List<String> getEmails() throws IOException {
        List<GHEmail> src = this.getEmails2();
        ArrayList<String> r = new ArrayList<String>(src.size());
        for (GHEmail e : src) {
            r.add(e.getEmail());
        }
        return r;
    }

    public List<GHEmail> getEmails2() throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath("/user/emails")).toIterable(GHEmail[].class, null).toList();
    }

    public List<GHKey> getPublicKeys() throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath("/user/keys")).toIterable(GHKey[].class, null).toList();
    }

    public List<GHVerifiedKey> getPublicVerifiedKeys() throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath("/users/" + this.getLogin() + "/keys")).toIterable(GHVerifiedKey[].class, null).toList();
    }

    public GHPersonSet<GHOrganization> getAllOrganizations() throws IOException {
        GHPersonSet<GHOrganization> orgs = new GHPersonSet<GHOrganization>();
        HashSet<String> names = new HashSet<String>();
        for (GHOrganization o : (GHOrganization[])((Requester)this.root.createRequest().withUrlPath("/user/orgs")).toIterable(GHOrganization[].class, null).toArray()) {
            if (!names.add(o.getLogin())) continue;
            orgs.add(this.root.getOrganization(o.getLogin()));
        }
        return orgs;
    }

    public synchronized Map<String, GHRepository> getAllRepositories() throws IOException {
        TreeMap<String, GHRepository> repositories = new TreeMap<String, GHRepository>();
        for (GHRepository r : this.listAllRepositories()) {
            repositories.put(r.getName(), r);
        }
        return Collections.unmodifiableMap(repositories);
    }

    @Override
    public PagedIterable<GHRepository> listRepositories() {
        return this.listRepositories(30);
    }

    @Override
    public PagedIterable<GHRepository> listRepositories(int pageSize) {
        return this.listRepositories(pageSize, RepositoryListFilter.ALL);
    }

    public PagedIterable<GHRepository> listRepositories(int pageSize, RepositoryListFilter repoType) {
        return ((Requester)((Requester)this.root.createRequest().with("type", repoType)).withUrlPath("/user/repos")).toIterable(GHRepository[].class, item -> item.wrap(this.root)).withPageSize(pageSize);
    }

    @Deprecated
    public PagedIterable<GHRepository> listAllRepositories() {
        return this.listRepositories();
    }

    public PagedIterable<GHMembership> listOrgMemberships() {
        return this.listOrgMemberships(null);
    }

    public PagedIterable<GHMembership> listOrgMemberships(GHMembership.State state) {
        return ((Requester)((Requester)this.root.createRequest().with("state", state)).withUrlPath("/user/memberships/orgs")).toIterable(GHMembership[].class, item -> item.wrap(this.root));
    }

    public GHMembership getMembership(GHOrganization o) throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath("/user/memberships/orgs/" + o.getLogin())).fetch(GHMembership.class).wrap(this.root);
    }

    public static enum RepositoryListFilter {
        ALL,
        OWNER,
        PUBLIC,
        PRIVATE,
        MEMBER;

    }
}

