/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.Requester;

public class GHCommitBuilder {
    private final GHRepository repo;
    private final Requester req;
    private final List<String> parents = new ArrayList<String>();

    GHCommitBuilder(GHRepository repo) {
        this.repo = repo;
        this.req = (Requester)repo.root.createRequest().method("POST");
    }

    public GHCommitBuilder message(String message) {
        this.req.with("message", message);
        return this;
    }

    public GHCommitBuilder tree(String tree) {
        this.req.with("tree", tree);
        return this;
    }

    public GHCommitBuilder parent(String parent) {
        this.parents.add(parent);
        return this;
    }

    public GHCommitBuilder author(String name, String email, Date date) {
        this.req.with("author", new UserInfo(name, email, date));
        return this;
    }

    public GHCommitBuilder committer(String name, String email, Date date) {
        this.req.with("committer", new UserInfo(name, email, date));
        return this;
    }

    private String getApiTail() {
        return String.format("/repos/%s/%s/git/commits", this.repo.getOwnerName(), this.repo.getName());
    }

    public GHCommit create() throws IOException {
        this.req.with("parents", this.parents);
        return ((Requester)((Requester)this.req.method("POST")).withUrlPath(this.getApiTail(), new String[0])).fetch(GHCommit.class).wrapUp(this.repo);
    }

    private static final class UserInfo {
        private final String name;
        private final String email;
        private final String date;

        private UserInfo(String name, String email, Date date) {
            this.name = name;
            this.email = email;
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            df.setTimeZone(tz);
            this.date = df.format(date != null ? date : new Date());
        }
    }
}

