/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import org.kohsuke.github.AbstractBuilder;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Previews;

abstract class GHRepositoryBuilder<S>
extends AbstractBuilder<GHRepository, S> {
    protected GHRepositoryBuilder(Class<S> intermediateReturnType, GitHub root, GHRepository baseInstance) {
        super(GHRepository.class, intermediateReturnType, root, baseInstance);
    }

    public S allowSquashMerge(boolean enabled) throws IOException {
        return this.with("allow_squash_merge", enabled);
    }

    public S allowMergeCommit(boolean enabled) throws IOException {
        return this.with("allow_merge_commit", enabled);
    }

    public S allowRebaseMerge(boolean enabled) throws IOException {
        return this.with("allow_rebase_merge", enabled);
    }

    public S deleteBranchOnMerge(boolean enabled) throws IOException {
        return this.with("delete_branch_on_merge", enabled);
    }

    public S defaultBranch(String branch) throws IOException {
        return this.with("default_branch", branch);
    }

    public S description(String description) throws IOException {
        return this.with("description", description);
    }

    public S homepage(URL homepage) throws IOException {
        return this.homepage(homepage.toExternalForm());
    }

    public S homepage(String homepage) throws IOException {
        return this.with("homepage", homepage);
    }

    public S private_(boolean enabled) throws IOException {
        return this.with("private", enabled);
    }

    public S issues(boolean enabled) throws IOException {
        return this.with("has_issues", enabled);
    }

    public S projects(boolean enabled) throws IOException {
        return this.with("has_projects", enabled);
    }

    public S wiki(boolean enabled) throws IOException {
        return this.with("has_wiki", enabled);
    }

    public S downloads(boolean enabled) throws IOException {
        return this.with("has_downloads", enabled);
    }

    @Preview(value={Previews.BAPTISTE})
    @Deprecated
    public S isTemplate(boolean enabled) throws IOException {
        this.requester.withPreview(Previews.BAPTISTE);
        return this.with("is_template", enabled);
    }

    @Override
    public GHRepository done() throws IOException {
        return ((GHRepository)super.done()).wrap(this.root);
    }

    S archive() throws IOException {
        return this.with("archived", true);
    }

    S name(String name) throws IOException {
        return this.with("name", name);
    }
}

