/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Date;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubInteractiveObject;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="JSON API")
public class GHEventInfo
extends GitHubInteractiveObject {
    private ObjectNode payload;
    private long id;
    private String created_at;
    private String type;
    private GHEventRepository repo;
    private GHUser actor;
    private GHOrganization org;

    public GHEvent getType() {
        String t = this.type;
        if (t.endsWith("Event")) {
            t = t.substring(0, t.length() - 5);
        }
        for (GHEvent e : GHEvent.values()) {
            if (!e.name().replace("_", "").equalsIgnoreCase(t)) continue;
            return e;
        }
        return null;
    }

    GHEventInfo wrapUp(GitHub root) {
        this.root = root;
        return this;
    }

    public long getId() {
        return this.id;
    }

    public Date getCreatedAt() {
        return GitHubClient.parseDate(this.created_at);
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="The field comes from JSON deserialization")
    public GHRepository getRepository() throws IOException {
        return this.root.getRepository(this.repo.name);
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="The field comes from JSON deserialization")
    public GHUser getActor() throws IOException {
        return this.root.getUser(this.actor.getLogin());
    }

    public String getActorLogin() throws IOException {
        return this.actor.getLogin();
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="The field comes from JSON deserialization")
    public GHOrganization getOrganization() throws IOException {
        return this.org == null || this.org.getLogin() == null ? null : this.root.getOrganization(this.org.getLogin());
    }

    public <T extends GHEventPayload> T getPayload(Class<T> type) throws IOException {
        GHEventPayload v = (GHEventPayload)GitHubClient.getMappingObjectReader(this.root).readValue(this.payload.traverse(), type);
        v.wrapUp(this.root);
        return (T)v;
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="JSON API")
    public static class GHEventRepository {
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        private long id;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        private String url;
        private String name;
    }
}

