/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHIssueEvent;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHMilestone;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHReaction;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Reactable;
import org.kohsuke.github.ReactionContent;
import org.kohsuke.github.Requester;
import org.kohsuke.github.SkipFromToString;
import org.kohsuke.github.internal.Previews;

@BridgeMethodsAdded
public class GHIssue
extends GHObject
implements Reactable {
    private static final String ASSIGNEES = "assignees";
    GHRepository owner;
    protected GHUser assignee;
    protected GHUser[] assignees;
    protected String state;
    protected int number;
    protected String closed_at;
    protected int comments;
    @SkipFromToString
    protected String body;
    protected List<GHLabel> labels;
    protected GHUser user;
    protected String title;
    protected String html_url;
    protected PullRequest pull_request;
    protected GHMilestone milestone;
    protected GHUser closed_by;
    protected boolean locked;

    GHIssue wrap(GHRepository owner) {
        this.owner = owner;
        if (this.milestone != null) {
            this.milestone.wrap(owner);
        }
        return this.wrap(owner.root);
    }

    GHIssue wrap(GitHub root) {
        this.root = root;
        if (this.assignee != null) {
            this.assignee.wrapUp(root);
        }
        if (this.assignees != null) {
            GHUser.wrap(this.assignees, root);
        }
        if (this.user != null) {
            this.user.wrapUp(root);
        }
        if (this.closed_by != null) {
            this.closed_by.wrapUp(root);
        }
        return this;
    }

    public GHRepository getRepository() {
        return this.owner;
    }

    public String getBody() {
        return this.body;
    }

    public int getNumber() {
        return this.number;
    }

    @Override
    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.html_url);
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public GHIssueState getState() {
        return Enum.valueOf(GHIssueState.class, this.state.toUpperCase(Locale.ENGLISH));
    }

    public Collection<GHLabel> getLabels() {
        if (this.labels == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.labels);
    }

    public Date getClosedAt() {
        return GitHubClient.parseDate(this.closed_at);
    }

    @Deprecated
    public URL getApiURL() {
        return this.getUrl();
    }

    public void lock() throws IOException {
        ((Requester)((Requester)this.root.createRequest().method("PUT")).withUrlPath(this.getApiRoute() + "/lock", new String[0])).send();
    }

    public void unlock() throws IOException {
        ((Requester)((Requester)this.root.createRequest().method("PUT")).withUrlPath(this.getApiRoute() + "/lock", new String[0])).send();
    }

    @WithBridgeMethods(value={void.class})
    public GHIssueComment comment(String message) throws IOException {
        GHIssueComment r = ((Requester)((Requester)((Requester)this.root.createRequest().method("POST")).with("body", message)).withUrlPath(this.getIssuesApiRoute() + "/comments", new String[0])).fetch(GHIssueComment.class);
        return r.wrapUp(this);
    }

    private void edit(String key, Object value) throws IOException {
        ((Requester)((Requester)((Requester)this.root.createRequest().with(key, value)).method("PATCH")).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    private void editNullable(String key, Object value) throws IOException {
        ((Requester)((Requester)((Requester)this.root.createRequest().withNullable(key, value)).method("PATCH")).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    private void editIssue(String key, Object value) throws IOException {
        ((Requester)((Requester)((Requester)this.root.createRequest().withNullable(key, value)).method("PATCH")).withUrlPath(this.getIssuesApiRoute(), new String[0])).send();
    }

    public void close() throws IOException {
        this.edit("state", "closed");
    }

    public void reopen() throws IOException {
        this.edit("state", "open");
    }

    public void setTitle(String title) throws IOException {
        this.edit("title", title);
    }

    public void setBody(String body) throws IOException {
        this.edit("body", body);
    }

    public void setMilestone(GHMilestone milestone) throws IOException {
        if (milestone == null) {
            this.editIssue("milestone", null);
        } else {
            this.editIssue("milestone", milestone.getNumber());
        }
    }

    public void assignTo(GHUser user) throws IOException {
        this.setAssignees(user);
    }

    public void setLabels(String ... labels) throws IOException {
        this.editIssue("labels", labels);
    }

    public void addLabels(String ... names) throws IOException {
        this._addLabels(Arrays.asList(names));
    }

    public void addLabels(GHLabel ... labels) throws IOException {
        this.addLabels(Arrays.asList(labels));
    }

    public void addLabels(Collection<GHLabel> labels) throws IOException {
        this._addLabels(GHLabel.toNames(labels));
    }

    private void _addLabels(Collection<String> names) throws IOException {
        ArrayList<String> newLabels = new ArrayList<String>();
        for (GHLabel label : this.getLabels()) {
            newLabels.add(label.getName());
        }
        for (String name : names) {
            if (newLabels.contains(name)) continue;
            newLabels.add(name);
        }
        this.setLabels(newLabels.toArray(new String[0]));
    }

    public void removeLabels(String ... names) throws IOException {
        this._removeLabels(Arrays.asList(names));
    }

    public void removeLabels(GHLabel ... labels) throws IOException {
        this.removeLabels(Arrays.asList(labels));
    }

    public void removeLabels(Collection<GHLabel> labels) throws IOException {
        this._removeLabels(GHLabel.toNames(labels));
    }

    private void _removeLabels(Collection<String> names) throws IOException {
        ArrayList<String> newLabels = new ArrayList<String>();
        for (GHLabel l : this.getLabels()) {
            if (names.contains(l.getName())) continue;
            newLabels.add(l.getName());
        }
        this.setLabels(newLabels.toArray(new String[0]));
    }

    public List<GHIssueComment> getComments() throws IOException {
        return this.listComments().toList();
    }

    public PagedIterable<GHIssueComment> listComments() throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(this.getIssuesApiRoute() + "/comments", new String[0])).toIterable(GHIssueComment[].class, item -> item.wrapUp(this));
    }

    @Override
    @Preview(value={Previews.SQUIRREL_GIRL})
    @Deprecated
    public GHReaction createReaction(ReactionContent content) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)this.root.createRequest().method("POST")).withPreview(Previews.SQUIRREL_GIRL)).with("content", content.getContent())).withUrlPath(this.getApiRoute() + "/reactions", new String[0])).fetch(GHReaction.class).wrap(this.root);
    }

    @Override
    @Preview(value={Previews.SQUIRREL_GIRL})
    @Deprecated
    public PagedIterable<GHReaction> listReactions() {
        return ((Requester)((Requester)this.root.createRequest().withPreview(Previews.SQUIRREL_GIRL)).withUrlPath(this.getApiRoute() + "/reactions", new String[0])).toIterable(GHReaction[].class, item -> item.wrap(this.root));
    }

    public void addAssignees(GHUser ... assignees) throws IOException {
        this.addAssignees(Arrays.asList(assignees));
    }

    public void addAssignees(Collection<GHUser> assignees) throws IOException {
        ((Requester)((Requester)((Requester)this.root.createRequest().method("POST")).with(ASSIGNEES, GHIssue.getLogins(assignees))).withUrlPath(this.getIssuesApiRoute() + "/assignees", new String[0])).fetchInto(this);
    }

    public void setAssignees(GHUser ... assignees) throws IOException {
        this.setAssignees(Arrays.asList(assignees));
    }

    public void setAssignees(Collection<GHUser> assignees) throws IOException {
        ((Requester)((Requester)((Requester)this.root.createRequest().method("PATCH")).with(ASSIGNEES, GHIssue.getLogins(assignees))).withUrlPath(this.getIssuesApiRoute(), new String[0])).send();
    }

    public void removeAssignees(GHUser ... assignees) throws IOException {
        this.removeAssignees(Arrays.asList(assignees));
    }

    public void removeAssignees(Collection<GHUser> assignees) throws IOException {
        ((Requester)((Requester)((Requester)((Requester)this.root.createRequest().method("DELETE")).with(ASSIGNEES, GHIssue.getLogins(assignees))).inBody()).withUrlPath(this.getIssuesApiRoute() + "/assignees", new String[0])).fetchInto(this);
    }

    protected String getApiRoute() {
        return this.getIssuesApiRoute();
    }

    protected String getIssuesApiRoute() {
        if (this.owner == null) {
            URL url = Objects.requireNonNull(this.getUrl(), "Missing instance URL!");
            return StringUtils.prependIfMissing((String)url.toString().replace(this.root.getApiUrl(), ""), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        return "/repos/" + this.owner.getOwnerName() + "/" + this.owner.getName() + "/issues/" + this.number;
    }

    public GHUser getAssignee() throws IOException {
        return this.root.intern(this.assignee);
    }

    public List<GHUser> getAssignees() {
        return Collections.unmodifiableList(Arrays.asList(this.assignees));
    }

    public GHUser getUser() throws IOException {
        return this.root.intern(this.user);
    }

    public GHUser getClosedBy() throws IOException {
        if (!"closed".equals(this.state)) {
            return null;
        }
        return this.root.intern(this.closed_by);
    }

    public int getCommentsCount() {
        return this.comments;
    }

    public PullRequest getPullRequest() {
        return this.pull_request;
    }

    public boolean isPullRequest() {
        return this.pull_request != null;
    }

    public GHMilestone getMilestone() {
        return this.milestone;
    }

    protected static List<String> getLogins(Collection<GHUser> users) {
        ArrayList<String> names = new ArrayList<String>(users.size());
        for (GHUser a : users) {
            names.add(a.getLogin());
        }
        return names;
    }

    public PagedIterable<GHIssueEvent> listEvents() throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(this.owner.getApiTailUrl(String.format("/issues/%s/events", this.number)), new String[0])).toIterable(GHIssueEvent[].class, item -> item.wrapUp(this));
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD"}, justification="JSON API")
    public static class PullRequest {
        private String diff_url;
        private String patch_url;
        private String html_url;

        public URL getDiffUrl() {
            return GitHubClient.parseURL(this.diff_url);
        }

        public URL getPatchUrl() {
            return GitHubClient.parseURL(this.patch_url);
        }

        public URL getUrl() {
            return GitHubClient.parseURL(this.html_url);
        }
    }
}

