/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.GitHubResponse;

class GitHubPageIterator<T>
implements Iterator<T> {
    private final GitHubClient client;
    private final Class<T> type;
    private T next;
    private GitHubRequest nextRequest;
    private GitHubResponse<T> finalResponse = null;

    private GitHubPageIterator(GitHubClient client, Class<T> type, GitHubRequest request) {
        if (!"GET".equals(request.method())) {
            throw new IllegalStateException("Request method \"GET\" is required for page iterator.");
        }
        this.client = client;
        this.type = type;
        this.nextRequest = request;
    }

    static <T> GitHubPageIterator<T> create(GitHubClient client, Class<T> type, GitHubRequest request, int pageSize) {
        if (pageSize > 0) {
            Object builder = request.toBuilder().with("per_page", pageSize);
            request = ((GitHubRequest.Builder)builder).build();
        }
        return new GitHubPageIterator<T>(client, type, request);
    }

    @Override
    public boolean hasNext() {
        this.fetch();
        return this.next != null;
    }

    @Override
    @Nonnull
    public T next() {
        this.fetch();
        T result = this.next;
        if (result == null) {
            throw new NoSuchElementException();
        }
        this.next = null;
        return result;
    }

    public GitHubResponse<T> finalResponse() {
        if (this.hasNext()) {
            throw new GHException("Final response is not available until after iterator is done.");
        }
        return this.finalResponse;
    }

    private void fetch() {
        if (this.next != null) {
            return;
        }
        if (this.nextRequest == null) {
            return;
        }
        URL url = this.nextRequest.url();
        try {
            GitHubResponse nextResponse = this.client.sendRequest(this.nextRequest, responseInfo -> GitHubResponse.parseBody(responseInfo, this.type));
            assert (nextResponse.body() != null);
            this.next = nextResponse.body();
            this.nextRequest = this.findNextURL(nextResponse);
            if (this.nextRequest == null) {
                this.finalResponse = nextResponse;
            }
        }
        catch (IOException e) {
            throw new GHException("Failed to retrieve " + url, e);
        }
    }

    private GitHubRequest findNextURL(GitHubResponse<T> nextResponse) throws MalformedURLException {
        GitHubRequest result = null;
        String link = nextResponse.headerField("Link");
        if (link != null) {
            for (String token : link.split(", ")) {
                if (!token.endsWith("rel=\"next\"")) continue;
                int idx = token.indexOf(62);
                result = ((GitHubRequest.Builder)nextResponse.request().toBuilder().setRawUrlPath(token.substring(1, idx))).build();
                break;
            }
        }
        return result;
    }
}

