/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.kohsuke.github.ApiVersion;
import org.kohsuke.github.GitHub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Poster {
    private final GitHub root;
    private final List<Entry> args = new ArrayList<Entry>();
    private boolean authenticate;
    private final ApiVersion v;

    Poster(GitHub root, ApiVersion v) {
        this.root = root;
        this.v = v;
    }

    Poster(GitHub root) {
        this(root, ApiVersion.V2);
    }

    public Poster withCredential() {
        this.root.requireCredential();
        this.authenticate = true;
        return this;
    }

    public Poster with(String key, int value) {
        return this._with(key, value);
    }

    public Poster with(String key, boolean value) {
        return this._with(key, value);
    }

    public Poster with(String key, String value) {
        return this._with(key, value);
    }

    private Poster _with(String key, Object value) {
        if (value != null) {
            this.args.add(new Entry(key, value));
        }
        return this;
    }

    public void to(String tailApiUrl) throws IOException {
        this.to(tailApiUrl, null);
    }

    public <T> T to(String tailApiUrl, Class<T> type) throws IOException {
        return this.to(tailApiUrl, type, "POST");
    }

    public <T> T to(String tailApiUrl, Class<T> type, String method) throws IOException {
        while (true) {
            HttpURLConnection uc = (HttpURLConnection)this.root.getApiURL(this.v, tailApiUrl).openConnection();
            uc.setDoOutput(true);
            uc.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            if (this.authenticate) {
                if (this.v == ApiVersion.V3) {
                    if (this.root.password == null) {
                        throw new IllegalArgumentException("V3 API doesn't support API token");
                    }
                    uc.setRequestProperty("Authorization", "Basic " + this.root.encodedAuthorization);
                } else {
                    uc.setRequestProperty("Authorization", "Basic " + this.root.encodedAuthorization);
                }
            }
            uc.setRequestMethod(method);
            if (this.v == ApiVersion.V2) {
                StringBuilder body = new StringBuilder();
                for (Entry e : this.args) {
                    if (body.length() > 0) {
                        body.append('&');
                    }
                    body.append(e.toFormArg());
                }
                OutputStreamWriter o = new OutputStreamWriter(uc.getOutputStream(), "UTF-8");
                o.write(body.toString());
                o.close();
            } else {
                HashMap<String, Object> json = new HashMap<String, Object>();
                for (Entry e : this.args) {
                    json.put(e.key, e.value);
                }
                GitHub.MAPPER.writeValue(uc.getOutputStream(), json);
            }
            try {
                InputStreamReader r = new InputStreamReader(uc.getInputStream(), "UTF-8");
                String data = IOUtils.toString((Reader)r);
                if (type == null) {
                    return null;
                }
                return (T)GitHub.MAPPER.readValue(data, type);
            }
            catch (IOException e) {
                this.root.handleApiError(e, uc);
                continue;
            }
            break;
        }
    }

    private static class Entry {
        String key;
        Object value;

        private Entry(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String toFormArg() throws UnsupportedEncodingException {
            return URLEncoder.encode(this.key, "UTF-8") + '=' + URLEncoder.encode(this.value.toString(), "UTF-8");
        }
    }
}

