/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.kohsuke.github.DeleteToken;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.JsonCollaborators;
import org.kohsuke.github.JsonRepository;
import org.kohsuke.github.Poster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHRepository {
    GitHub root;
    private String description;
    private String homepage;
    private String url;
    private String name;
    private String owner;
    private boolean has_issues;
    private boolean has_wiki;
    private boolean fork;
    private boolean _private;
    private boolean has_downloads;
    private int watchers;
    private int forks;

    public String getDescription() {
        return this.description;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public GHUser getOwner() throws IOException {
        return this.root.getUser(this.owner);
    }

    public boolean hasIssues() {
        return this.has_issues;
    }

    public boolean hasWiki() {
        return this.has_wiki;
    }

    public boolean isFork() {
        return this.fork;
    }

    public int getForks() {
        return this.forks;
    }

    public boolean isPrivate() {
        return this._private;
    }

    public boolean hasDownloads() {
        return this.has_downloads;
    }

    public int getWatchers() {
        return this.watchers;
    }

    public Set<GHUser> getCollaborators() throws IOException {
        HashSet<GHUser> r = new HashSet<GHUser>();
        for (String u : this.root.retrieve((String)new StringBuilder().append((String)"/repos/show/").append((String)this.owner).append((String)"/").append((String)this.name).append((String)"/collaborators").toString(), JsonCollaborators.class).collaborators) {
            r.add(this.root.getUser(u));
        }
        return Collections.unmodifiableSet(r);
    }

    public void addCollaborators(GHUser ... users) throws IOException {
        this.addCollaborators(Arrays.asList(users));
    }

    public void addCollaborators(Collection<GHUser> users) throws IOException {
        this.modifyCollaborators(users, "/add/");
    }

    public void removeCollaborators(GHUser ... users) throws IOException {
        this.removeCollaborators(Arrays.asList(users));
    }

    public void removeCollaborators(Collection<GHUser> users) throws IOException {
        this.modifyCollaborators(users, "/remove/");
    }

    private void modifyCollaborators(Collection<GHUser> users, String op) throws IOException {
        this.verifyMine();
        for (GHUser user : users) {
            new Poster(this.root).withCredential().to(this.root.getApiURL("/repos/collaborators/" + this.name + op + user.getLogin()));
        }
    }

    public void delete() throws IOException {
        this.verifyMine();
        Poster poster = new Poster(this.root).withCredential();
        URL url = this.root.getApiURL("/repos/delete/" + this.name);
        DeleteToken token = poster.to(url, DeleteToken.class);
        poster.with("delete_token", token.delete_token).to(url);
    }

    public GHRepository fork() throws IOException {
        GHRepository r = new Poster((GitHub)this.root).withCredential().to((URL)this.root.getApiURL((String)new StringBuilder().append((String)"/repos/fork/").append((String)this.owner).append((String)"/").append((String)this.name).toString()), JsonRepository.class).repository;
        r.root = this.root;
        return r;
    }

    private void verifyMine() throws IOException {
        if (!this.root.login.equals(this.owner)) {
            throw new IOException("Operation not applicable to a repository owned by someone else: " + this.owner);
        }
    }

    public String toString() {
        return "Repository:" + this.owner + ":" + this.name;
    }
}

