/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.introspect.VisibilityChecker;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.JsonRepository;
import org.kohsuke.github.JsonUser;
import org.kohsuke.github.Poster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitHub {
    final String login;
    final String token;
    private final Map<String, GHUser> users = new HashMap<String, GHUser>();
    static final ObjectMapper MAPPER = new ObjectMapper();

    private GitHub(String login, String apiToken) {
        this.login = login;
        this.token = apiToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GitHub connect() throws IOException {
        Properties props = new Properties();
        File homeDir = new File(System.getProperty("user.home"));
        FileInputStream in = new FileInputStream(new File(homeDir, ".github"));
        try {
            props.load(in);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return new GitHub(props.getProperty("login"), props.getProperty("token"));
    }

    public static GitHub connect(String login, String apiToken) throws IOException {
        return new GitHub(login, apiToken);
    }

    public static GitHub connectAnonymously() {
        return new GitHub(null, null);
    }

    void requireCredential() {
        if (this.login == null || this.token == null) {
            throw new IllegalStateException("This operation requires a credential but none is given to the GitHub constructor");
        }
    }

    URL getApiURL(String tail) throws IOException {
        return new URL("http://github.com/api/v2/json" + tail);
    }

    <T> T retrieve(String tail, Class<T> type) throws IOException {
        return (T)MAPPER.readValue(this.getApiURL(tail), type);
    }

    public GHUser getUser(String login) throws IOException {
        GHUser u = this.users.get(login);
        if (u == null) {
            u = ((JsonUser)GitHub.MAPPER.readValue((URL)this.getApiURL((String)new StringBuilder().append((String)"/user/show/").append((String)login).toString()), JsonUser.class)).user;
            u.root = this;
            this.users.put(login, u);
        }
        return u;
    }

    public GHUser getMyself() throws IOException {
        this.requireCredential();
        return this.getUser(this.login);
    }

    public GHRepository createRepository(String name, String description, String homepage, boolean isPublic) throws IOException {
        GHRepository r = new Poster((GitHub)this).withCredential().with((String)"name", (String)name).with((String)"description", (String)description).with((String)"homepage", (String)homepage).with((String)"public", (int)(isPublic ? 1 : 0)).to((URL)this.getApiURL((String)"/repos/create"), JsonRepository.class).repository;
        r.root = this;
        return r;
    }

    static {
        MAPPER.setVisibilityChecker((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY));
        MAPPER.getDeserializationConfig().set(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

