/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kohsuke.github.ApiVersion;
import org.kohsuke.github.GHCommitComment;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.Poster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHCommit {
    private GHRepository owner;
    String url;
    String sha;
    List<File> files;
    Stats stats;
    List<Parent> parents;
    User author;
    User committer;

    public GHRepository getOwner() {
        return this.owner;
    }

    public int getLinesChanged() {
        return this.stats.total;
    }

    public int getLinesAdded() {
        return this.stats.additions;
    }

    public int getLinesDeleted() {
        return this.stats.deletions;
    }

    public String getSHA1() {
        return this.sha;
    }

    public List<File> getFiles() {
        return this.files != null ? Collections.unmodifiableList(this.files) : Collections.emptyList();
    }

    public List<String> getParentSHA1s() {
        if (this.parents == null) {
            return Collections.emptyList();
        }
        return new AbstractList<String>(){

            @Override
            public String get(int index) {
                return GHCommit.this.parents.get((int)index).sha;
            }

            @Override
            public int size() {
                return GHCommit.this.parents.size();
            }
        };
    }

    public List<GHCommit> getParents() throws IOException {
        ArrayList<GHCommit> r = new ArrayList<GHCommit>();
        for (String sha1 : this.getParentSHA1s()) {
            r.add(this.owner.getCommit(sha1));
        }
        return r;
    }

    public GHUser getAuthor() throws IOException {
        return this.resolveUser(this.author);
    }

    public GHUser getCommitter() throws IOException {
        return this.resolveUser(this.committer);
    }

    private GHUser resolveUser(User author) throws IOException {
        if (author == null || author.login == null) {
            return null;
        }
        return this.owner.root.getUser(author.login);
    }

    public PagedIterable<GHCommitComment> listComments() {
        return new PagedIterable<GHCommitComment>(){

            @Override
            public PagedIterator<GHCommitComment> iterator() {
                return new PagedIterator<GHCommitComment>(((GHCommit)GHCommit.this).owner.root.retrievePaged(String.format("/repos/%s/%s/commits/%s/comments", GHCommit.this.owner.getOwnerName(), GHCommit.this.owner.getName(), GHCommit.this.sha), GHCommitComment[].class, false, ApiVersion.V3)){

                    protected void wrapUp(GHCommitComment[] page) {
                        for (GHCommitComment c : page) {
                            c.wrap(GHCommit.this.owner);
                        }
                    }
                };
            }
        };
    }

    public GHCommitComment createComment(String body, String path, Integer line, Integer position) throws IOException {
        GHCommitComment r = new Poster(this.owner.root, ApiVersion.V3).with("body", body).with("path", path).with("line", line).with("position", position).withCredential().to(String.format("/repos/%s/%s/commits/%s/comments", this.owner.getOwnerName(), this.owner.getName(), this.sha), GHCommitComment.class);
        return r.wrap(this.owner);
    }

    public GHCommitComment createComment(String body) throws IOException {
        return this.createComment(body, null, null, null);
    }

    GHCommit wrapUp(GHRepository owner) {
        this.owner = owner;
        return this;
    }

    static class User {
        String url;
        String avatar_url;
        String login;
        String gravatar_id;
        int id;

        User() {
        }
    }

    public static class Parent {
        String url;
        String sha;
    }

    public static class File {
        String status;
        int changes;
        int additions;
        int deletions;
        String raw_url;
        String blob_url;
        String filename;
        String sha;
        String patch;

        public int getLinesChanged() {
            return this.changes;
        }

        public int getLinesAdded() {
            return this.additions;
        }

        public int getLinesDeleted() {
            return this.deletions;
        }

        public String getStatus() {
            return this.status;
        }

        public String getFileName() {
            return this.filename;
        }

        public String getPatch() {
            return this.patch;
        }

        public URL getRawUrl() {
            return GitHub.parseURL(this.raw_url);
        }

        public URL getBlobUrl() {
            return GitHub.parseURL(this.blob_url);
        }

        public String getSha() {
            return this.sha;
        }
    }

    public static class Stats {
        int total;
        int additions;
        int deletions;
    }
}

