/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.kohsuke.github.ApiVersion;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.Poster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GHHook {
    transient GHRepository repository;
    String created_at;
    String updated_at;
    String name;
    List<String> events;
    boolean active;
    Map<String, String> config;
    int id;

    GHHook wrap(GHRepository owner) {
        this.repository = owner;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public EnumSet<GHEvent> getEvents() {
        EnumSet<GHEvent> s = EnumSet.noneOf(GHEvent.class);
        for (String e : this.events) {
            Enum.valueOf(GHEvent.class, e.toUpperCase(Locale.ENGLISH));
        }
        return s;
    }

    public boolean isActive() {
        return this.active;
    }

    public Map<String, String> getConfig() {
        return Collections.unmodifiableMap(this.config);
    }

    public int getId() {
        return this.id;
    }

    public void delete() throws IOException {
        new Poster(this.repository.root, ApiVersion.V3).withCredential().to(String.format("/repos/%s/%s/hooks/%d", this.repository.getOwnerName(), this.repository.getName(), this.id), null, "DELETE");
    }
}

