/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHPerson;
import org.kohsuke.github.GHPersonSet;
import org.kohsuke.github.JsonUsers;
import org.kohsuke.github.Poster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class GHUser
extends GHPerson {
    public void follow() throws IOException {
        new Poster(this.root).withCredential().to("/user/follow/" + this.login);
    }

    public void unfollow() throws IOException {
        new Poster(this.root).withCredential().to("/user/unfollow/" + this.login);
    }

    @WithBridgeMethods(value={Set.class})
    public GHPersonSet<GHUser> getFollows() throws IOException {
        return this.root.retrieve("/user/show/" + this.login + "/following", JsonUsers.class).toSet(this.root);
    }

    @WithBridgeMethods(value={Set.class})
    public GHPersonSet<GHUser> getFollowers() throws IOException {
        return this.root.retrieve("/user/show/" + this.login + "/followers", JsonUsers.class).toSet(this.root);
    }

    @WithBridgeMethods(value={Set.class})
    public GHPersonSet<GHOrganization> getOrganizations() throws IOException {
        GHPersonSet<GHOrganization> orgs = new GHPersonSet<GHOrganization>();
        HashSet<String> names = new HashSet<String>();
        for (GHOrganization o : this.root.retrieve3("/users/" + this.login + "/orgs", GHOrganization[].class)) {
            if (!names.add(o.getLogin())) continue;
            orgs.add(this.root.getOrganization(o.getLogin()));
        }
        return orgs;
    }

    public String toString() {
        return "User:" + this.login;
    }

    public int hashCode() {
        return this.login.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GHUser) {
            GHUser that = (GHUser)obj;
            return this.login.equals(that.login);
        }
        return false;
    }
}

