/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.kohsuke.github.GitHub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Poster {
    private final GitHub root;
    private final List<Entry> args = new ArrayList<Entry>();
    private boolean authenticate;

    Poster(GitHub root) {
        this.root = root;
    }

    public Poster withCredential() {
        this.root.requireCredential();
        this.authenticate = true;
        return this;
    }

    public Poster with(String key, int value) {
        return this._with(key, value);
    }

    public Poster with(String key, Integer value) {
        if (value != null) {
            this._with(key, (int)value);
        }
        return this;
    }

    public Poster with(String key, boolean value) {
        return this._with(key, value);
    }

    public Poster with(String key, String value) {
        return this._with(key, value);
    }

    public Poster with(String key, Collection<String> value) {
        return this._with(key, value);
    }

    public Poster _with(String key, Object value) {
        if (value != null) {
            this.args.add(new Entry(key, value));
        }
        return this;
    }

    public void to(String tailApiUrl) throws IOException {
        this.to(tailApiUrl, null);
    }

    public <T> T to(String tailApiUrl, Class<T> type) throws IOException {
        return this.to(tailApiUrl, type, "POST");
    }

    public <T> T to(String tailApiUrl, Class<T> type, String method) throws IOException {
        while (true) {
            HttpURLConnection uc = (HttpURLConnection)this.root.getApiURL(tailApiUrl).openConnection();
            uc.setDoOutput(true);
            uc.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            if (this.authenticate) {
                if (this.root.oauthAccessToken != null) {
                    uc.setRequestProperty("Authorization", "token " + this.root.oauthAccessToken);
                } else {
                    if (this.root.password == null) {
                        throw new IllegalArgumentException("V3 API doesn't support API token");
                    }
                    uc.setRequestProperty("Authorization", "Basic " + this.root.encodedAuthorization);
                }
            }
            try {
                uc.setRequestMethod(method);
            }
            catch (ProtocolException e) {
                try {
                    Field $method = HttpURLConnection.class.getDeclaredField("method");
                    $method.setAccessible(true);
                    $method.set(uc, method);
                }
                catch (Exception x) {
                    throw (IOException)new IOException("Failed to set the custom verb").initCause(x);
                }
            }
            HashMap<String, Object> json = new HashMap<String, Object>();
            for (Entry e : this.args) {
                json.put(e.key, e.value);
            }
            GitHub.MAPPER.writeValue(uc.getOutputStream(), json);
            try {
                InputStreamReader r = new InputStreamReader(uc.getInputStream(), "UTF-8");
                String data = IOUtils.toString((Reader)r);
                if (type == null) {
                    return null;
                }
                return (T)GitHub.MAPPER.readValue(data, type);
            }
            catch (IOException e) {
                this.root.handleApiError(e, uc);
                continue;
            }
            break;
        }
    }

    private static class Entry {
        String key;
        Object value;

        private Entry(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

