/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import java.io.IOException;
import java.util.Map;
import org.kohsuke.github.GHPerson;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.JsonTeams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHOrganization
extends GHPerson {
    public GHRepository createRepository(String name, String description, String homepage, String team, boolean isPublic) throws IOException {
        WebClient wc = this.root.createWebClient();
        HtmlPage pg = (HtmlPage)wc.getPage("https://github.com/organizations/" + this.login + "/repositories/new");
        HtmlForm f = (HtmlForm)pg.getForms().get(1);
        f.getInputByName("repository[name]").setValueAttribute(name);
        f.getInputByName("repository[description]").setValueAttribute(description);
        f.getInputByName("repository[homepage]").setValueAttribute(homepage);
        f.getSelectByName("team_id").getOptionByText(team).setSelected(true);
        f.submit((SubmittableElement)f.getButtonByCaption("Create Repository"));
        return this.root.getUser(this.login).getRepository(name);
    }

    public Map<String, GHTeam> getTeams() throws IOException {
        return this.root.retrieveWithAuth(this.root.getApiURL("/organizations/" + this.login + "/teams"), JsonTeams.class).toMap(this);
    }
}

