/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHTeam {
    private String name;
    private String permission;
    private int id;
    protected GHOrganization org;

    GHTeam wrapUp(GHOrganization owner) {
        this.org = owner;
        return this;
    }

    static GHTeam[] wrapUp(GHTeam[] teams, GHOrganization owner) {
        for (GHTeam t : teams) {
            t.wrapUp(owner);
        }
        return teams;
    }

    public String getName() {
        return this.name;
    }

    public String getPermission() {
        return this.permission;
    }

    public int getId() {
        return this.id;
    }

    public Set<GHUser> getMembers() throws IOException {
        return new HashSet<GHUser>(Arrays.asList(GHUser.wrap(this.org.root.retrieveWithAuth(this.api("/members"), GHUser[].class), this.org.root)));
    }

    public Map<String, GHRepository> getRepositories() throws IOException {
        GHRepository[] repos = this.org.root.retrieveWithAuth(this.api("/repos"), GHRepository[].class);
        TreeMap<String, GHRepository> m = new TreeMap<String, GHRepository>();
        for (GHRepository r : repos) {
            m.put(r.getName(), r.wrap(this.org.root));
        }
        return m;
    }

    public void add(GHUser u) throws IOException {
        this.org.root.retrieveWithAuth(this.api("/members/" + u.getLogin()), null, "PUT");
    }

    public void remove(GHUser u) throws IOException {
        this.org.root.retrieveWithAuth(this.api("/members/" + u.getLogin()), null, "DELETE");
    }

    public void add(GHRepository r) throws IOException {
        this.org.root.retrieveWithAuth(this.api("/repos/" + r.getOwnerName() + '/' + r.getName()), null, "PUT");
    }

    public void remove(GHRepository r) throws IOException {
        this.org.root.retrieveWithAuth(this.api("/repos/" + r.getOwnerName() + '/' + r.getName()), null, "DELETE");
    }

    private String api(String tail) {
        return "/teams/" + this.id + tail;
    }
}

