/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonSetter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.kohsuke.github.GHAppInstallation;
import org.kohsuke.github.GHCheckRun;
import org.kohsuke.github.GHCheckSuite;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHCommitComment;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHDeployment;
import org.kohsuke.github.GHDeploymentStatus;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueChanges;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHLabelChanges;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestChanges;
import org.kohsuke.github.GHPullRequestReview;
import org.kohsuke.github.GHPullRequestReviewComment;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHRepositoryDiscussion;
import org.kohsuke.github.GHRequestedAction;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GHWorkflow;
import org.kohsuke.github.GHWorkflowRun;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubInteractiveObject;
import org.kohsuke.github.GitUser;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"}, justification="JSON API")
public abstract class GHEventPayload
extends GitHubInteractiveObject {
    private String action;
    private GHUser sender;
    private GHRepository repository;
    private GHOrganization organization;
    private GHAppInstallation installation;

    GHEventPayload() {
    }

    public String getAction() {
        return this.action;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
    public GHUser getSender() {
        return this.sender;
    }

    @Deprecated
    public void setSender(GHUser sender) {
        throw new RuntimeException("Do not use this method.");
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
    public GHRepository getRepository() {
        return this.repository;
    }

    @Deprecated
    public void setRepository(GHRepository repository) {
        throw new RuntimeException("Do not use this method.");
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
    public GHOrganization getOrganization() {
        return this.organization;
    }

    @Deprecated
    public void setOrganization(GHOrganization organization) {
        throw new RuntimeException("Do not use this method.");
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
    public GHAppInstallation getInstallation() {
        return this.installation;
    }

    void lateBind() {
    }

    public static class Discussion
    extends GHEventPayload {
        private GHRepositoryDiscussion discussion;
        private GHLabel label;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHRepositoryDiscussion getDiscussion() {
            return this.discussion;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHLabel getLabel() {
            return this.label;
        }
    }

    public static class Label
    extends GHEventPayload {
        private GHLabel label;
        private GHLabelChanges changes;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
        public GHLabel getLabel() {
            return this.label;
        }

        public GHLabelChanges getChanges() {
            return this.changes;
        }
    }

    public static class WorkflowRun
    extends GHEventPayload {
        private GHWorkflowRun workflowRun;
        private GHWorkflow workflow;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHWorkflowRun getWorkflowRun() {
            return this.workflowRun;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHWorkflow getWorkflow() {
            return this.workflow;
        }

        @Override
        void lateBind() {
            if (this.workflowRun == null || this.workflow == null) {
                throw new IllegalStateException("Expected workflow and workflow_run payload, but got something else. Maybe we've got another type of event?");
            }
            super.lateBind();
            GHRepository repository = this.getRepository();
            if (repository == null) {
                throw new IllegalStateException("Repository must not be null");
            }
            this.workflowRun.wrapUp(repository);
            this.workflow.wrapUp(repository);
        }
    }

    public static class WorkflowDispatch
    extends GHEventPayload {
        private Map<String, Object> inputs;
        private String ref;
        private String workflow;

        public Map<String, Object> getInputs() {
            return Collections.unmodifiableMap(this.inputs);
        }

        public String getRef() {
            return this.ref;
        }

        public String getWorkflow() {
            return this.workflow;
        }
    }

    public static class Status
    extends GHEventPayload {
        private String context;
        private String description;
        private GHCommitState state;
        private GHCommit commit;
        private String targetUrl;

        public String getContext() {
            return this.context;
        }

        public String getTargetUrl() {
            return this.targetUrl;
        }

        public String getDescription() {
            return this.description;
        }

        public GHCommitState getState() {
            return this.state;
        }

        @Deprecated
        public void setState(GHCommitState state) {
            throw new RuntimeException("Do not use this method.");
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHCommit getCommit() {
            return this.commit;
        }

        @Deprecated
        public void setCommit(GHCommit commit) {
            throw new RuntimeException("Do not use this method.");
        }

        @Override
        void lateBind() {
            if (this.state == null) {
                throw new IllegalStateException("Expected status payload, but got something else. Maybe we've got another type of event?");
            }
            super.lateBind();
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.commit.wrapUp(repository);
            }
        }
    }

    public static class Repository
    extends GHEventPayload {
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR", "NP_UNWRITTEN_FIELD"}, justification="Constructed by JSON deserialization")
    public static class Release
    extends GHEventPayload {
        private GHRelease release;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHRelease getRelease() {
            return this.release;
        }

        @Deprecated
        public void setRelease(GHRelease release) {
            throw new RuntimeException("Do not use this method.");
        }
    }

    public static class Push
    extends GHEventPayload {
        private String head;
        private String before;
        private boolean created;
        private boolean deleted;
        private boolean forced;
        private String ref;
        private int size;
        private List<PushCommit> commits;
        private Pusher pusher;
        private String compare;

        public String getHead() {
            return this.head;
        }

        public String getBefore() {
            return this.before;
        }

        @JsonSetter
        private void setAfter(String after) {
            this.head = after;
        }

        public String getRef() {
            return this.ref;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isCreated() {
            return this.created;
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public boolean isForced() {
            return this.forced;
        }

        public List<PushCommit> getCommits() {
            return Collections.unmodifiableList(this.commits);
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public Pusher getPusher() {
            return this.pusher;
        }

        @Deprecated
        public void setPusher(Pusher pusher) {
            throw new RuntimeException("Do not use this method.");
        }

        public String getCompare() {
            return this.compare;
        }

        public static class PushCommit {
            private GitUser author;
            private GitUser committer;
            private String url;
            private String sha;
            private String message;
            private String timestamp;
            private boolean distinct;
            private List<String> added;
            private List<String> removed;
            private List<String> modified;

            public GitUser getAuthor() {
                return this.author;
            }

            public GitUser getCommitter() {
                return this.committer;
            }

            public String getUrl() {
                return this.url;
            }

            public String getSha() {
                return this.sha;
            }

            @JsonSetter
            private void setId(String id) {
                this.sha = id;
            }

            public String getMessage() {
                return this.message;
            }

            public boolean isDistinct() {
                return this.distinct;
            }

            public List<String> getAdded() {
                return Collections.unmodifiableList(this.added);
            }

            public List<String> getRemoved() {
                return Collections.unmodifiableList(this.removed);
            }

            public List<String> getModified() {
                return Collections.unmodifiableList(this.modified);
            }

            public Date getTimestamp() {
                return GitHubClient.parseDate(this.timestamp);
            }
        }

        public static class Pusher {
            private String name;
            private String email;

            public String getName() {
                return this.name;
            }

            @Deprecated
            public void setName(String name) {
                throw new RuntimeException("Do not use this method.");
            }

            public String getEmail() {
                return this.email;
            }

            @Deprecated
            public void setEmail(String email) {
                throw new RuntimeException("Do not use this method.");
            }
        }
    }

    public static class Public
    extends GHEventPayload {
    }

    public static class Ping
    extends GHEventPayload {
    }

    public static class Fork
    extends GHEventPayload {
        private GHRepository forkee;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHRepository getForkee() {
            return this.forkee;
        }

        @Deprecated
        public void setForkee(GHRepository forkee) {
            throw new RuntimeException("Do not use this method.");
        }
    }

    public static class DeploymentStatus
    extends GHEventPayload {
        private GHDeploymentStatus deploymentStatus;
        private GHDeployment deployment;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHDeploymentStatus getDeploymentStatus() {
            return this.deploymentStatus;
        }

        @Deprecated
        public void setDeploymentStatus(GHDeploymentStatus deploymentStatus) {
            throw new RuntimeException("Do not use this method.");
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHDeployment getDeployment() {
            return this.deployment;
        }

        @Deprecated
        public void setDeployment(GHDeployment deployment) {
            throw new RuntimeException("Do not use this method.");
        }

        @Override
        void lateBind() {
            super.lateBind();
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.deployment.wrap(repository);
                this.deploymentStatus.lateBind(repository);
            }
        }
    }

    public static class Deployment
    extends GHEventPayload {
        private GHDeployment deployment;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHDeployment getDeployment() {
            return this.deployment;
        }

        @Deprecated
        public void setDeployment(GHDeployment deployment) {
            throw new RuntimeException("Do not use this method.");
        }

        @Override
        void lateBind() {
            super.lateBind();
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.deployment.wrap(repository);
            }
        }
    }

    public static class Delete
    extends GHEventPayload {
        private String ref;
        private String refType;

        public String getRef() {
            return this.ref;
        }

        public String getRefType() {
            return this.refType;
        }
    }

    public static class Create
    extends GHEventPayload {
        private String ref;
        private String refType;
        private String masterBranch;
        private String description;

        public String getRef() {
            return this.ref;
        }

        public String getRefType() {
            return this.refType;
        }

        public String getMasterBranch() {
            return this.masterBranch;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class CommitComment
    extends GHEventPayload {
        private GHCommitComment comment;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHCommitComment getComment() {
            return this.comment;
        }

        @Deprecated
        public void setComment(GHCommitComment comment) {
            throw new RuntimeException("Do not use this method.");
        }

        @Override
        void lateBind() {
            super.lateBind();
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.comment.wrap(repository);
            }
        }
    }

    public static class IssueComment
    extends GHEventPayload {
        private GHIssueComment comment;
        private GHIssue issue;
        private CommentChanges changes;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHIssueComment getComment() {
            return this.comment;
        }

        public CommentChanges getChanges() {
            return this.changes;
        }

        @Deprecated
        public void setComment(GHIssueComment comment) {
            throw new RuntimeException("Do not use this method.");
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHIssue getIssue() {
            return this.issue;
        }

        @Deprecated
        public void setIssue(GHIssue issue) {
            throw new RuntimeException("Do not use this method.");
        }

        @Override
        void lateBind() {
            super.lateBind();
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.issue.wrap(repository);
            }
            this.comment.wrapUp(this.issue);
        }
    }

    public static class Issue
    extends GHEventPayload {
        private GHIssue issue;
        private GHLabel label;
        private GHIssueChanges changes;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHIssue getIssue() {
            return this.issue;
        }

        @Deprecated
        public void setIssue(GHIssue issue) {
            throw new RuntimeException("Do not use this method.");
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHLabel getLabel() {
            return this.label;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHIssueChanges getChanges() {
            return this.changes;
        }

        @Override
        void lateBind() {
            super.lateBind();
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.issue.wrap(repository);
            }
        }
    }

    public static class PullRequestReviewComment
    extends GHEventPayload {
        private GHPullRequestReviewComment comment;
        private GHPullRequest pullRequest;
        private CommentChanges changes;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHPullRequestReviewComment getComment() {
            return this.comment;
        }

        public CommentChanges getChanges() {
            return this.changes;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHPullRequest getPullRequest() {
            return this.pullRequest;
        }

        @Override
        void lateBind() {
            if (this.comment == null) {
                throw new IllegalStateException("Expected pull_request_review_comment payload, but got something else. Maybe we've got another type of event?");
            }
            super.lateBind();
            this.comment.wrapUp(this.pullRequest);
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.pullRequest.wrapUp(repository);
            }
        }
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="JSON API")
    public static class CommentChanges {
        private GHFrom body;

        public GHFrom getBody() {
            return this.body;
        }

        public static class GHFrom {
            private String from;

            public String getFrom() {
                return this.from;
            }
        }
    }

    public static class PullRequestReview
    extends GHEventPayload {
        private GHPullRequestReview review;
        private GHPullRequest pullRequest;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHPullRequestReview getReview() {
            return this.review;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHPullRequest getPullRequest() {
            return this.pullRequest;
        }

        @Override
        void lateBind() {
            if (this.review == null) {
                throw new IllegalStateException("Expected pull_request_review payload, but got something else. Maybe we've got another type of event?");
            }
            super.lateBind();
            this.review.wrapUp(this.pullRequest);
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.pullRequest.wrapUp(repository);
            }
        }
    }

    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"}, justification="JSON API")
    public static class PullRequest
    extends GHEventPayload {
        private int number;
        private GHPullRequest pullRequest;
        private GHLabel label;
        private GHPullRequestChanges changes;

        public int getNumber() {
            return this.number;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHPullRequest getPullRequest() {
            return this.pullRequest;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHLabel getLabel() {
            return this.label;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHPullRequestChanges getChanges() {
            return this.changes;
        }

        @Override
        void lateBind() {
            if (this.pullRequest == null) {
                throw new IllegalStateException("Expected pull_request payload, but got something else. Maybe we've got another type of event?");
            }
            super.lateBind();
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.pullRequest.wrapUp(repository);
            }
        }
    }

    public static class InstallationRepositories
    extends GHEventPayload {
        private String repositorySelection;
        private List<GHRepository> repositoriesAdded;
        private List<GHRepository> repositoriesRemoved;

        public String getRepositorySelection() {
            return this.repositorySelection;
        }

        public List<GHRepository> getRepositoriesAdded() {
            return Collections.unmodifiableList(this.repositoriesAdded);
        }

        public List<GHRepository> getRepositoriesRemoved() {
            return Collections.unmodifiableList(this.repositoriesRemoved);
        }

        @Override
        void lateBind() {
            if (this.getInstallation() == null) {
                throw new IllegalStateException("Expected installation_repositories payload, but got something else. Maybe we've got another type of event?");
            }
            super.lateBind();
            List<GHRepository> repositories = "added".equals(this.getAction()) ? this.repositoriesAdded : this.repositoriesRemoved;
            if (repositories != null && !repositories.isEmpty()) {
                try {
                    for (GHRepository singleRepo : repositories) {
                        singleRepo.populate();
                    }
                }
                catch (IOException e) {
                    throw new GHException("Failed to refresh repositories", e);
                }
            }
        }
    }

    public static class Installation
    extends GHEventPayload {
        private List<GHRepository> repositories;

        public List<GHRepository> getRepositories() {
            return Collections.unmodifiableList(this.repositories);
        }

        @Override
        void lateBind() {
            if (this.getInstallation() == null) {
                throw new IllegalStateException("Expected installation payload, but got something else. Maybe we've got another type of event?");
            }
            super.lateBind();
            if (this.repositories != null && !this.repositories.isEmpty()) {
                try {
                    for (GHRepository singleRepo : this.repositories) {
                        singleRepo.populate();
                    }
                }
                catch (IOException e) {
                    throw new GHException("Failed to refresh repositories", e);
                }
            }
        }
    }

    public static class CheckSuite
    extends GHEventPayload {
        private GHCheckSuite checkSuite;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHCheckSuite getCheckSuite() {
            return this.checkSuite;
        }

        @Override
        void lateBind() {
            if (this.checkSuite == null) {
                throw new IllegalStateException("Expected check_suite payload, but got something else. Maybe we've got another type of event?");
            }
            super.lateBind();
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.checkSuite.wrap(repository);
            } else {
                this.checkSuite.wrap(this.root());
            }
        }
    }

    public static class CheckRun
    extends GHEventPayload {
        private int number;
        private GHCheckRun checkRun;
        private GHRequestedAction requestedAction;

        public int getNumber() {
            return this.number;
        }

        @Deprecated
        public void setCheckRun(GHCheckRun currentCheckRun) {
            throw new RuntimeException("Do not use this method.");
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHCheckRun getCheckRun() {
            return this.checkRun;
        }

        @Deprecated
        public void setRequestedAction(GHRequestedAction currentRequestedAction) {
            throw new RuntimeException("Do not use this method.");
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHRequestedAction getRequestedAction() {
            return this.requestedAction;
        }

        @Override
        void lateBind() {
            if (this.checkRun == null) {
                throw new IllegalStateException("Expected check_run payload, but got something else. Maybe we've got another type of event?");
            }
            super.lateBind();
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.checkRun.wrap(repository);
            } else {
                this.checkRun.wrap(this.root());
            }
        }
    }
}

