/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHPerson;
import org.kohsuke.github.GHPersonSet;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Poster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class GHUser
extends GHPerson {
    public void follow() throws IOException {
        new Poster(this.root).withCredential().to("/user/following/" + this.login, null, "PUT");
    }

    public void unfollow() throws IOException {
        new Poster(this.root).withCredential().to("/user/following/" + this.login, null, "DELETE");
    }

    @WithBridgeMethods(value={Set.class})
    public GHPersonSet<GHUser> getFollows() throws IOException {
        GHUser[] followers = this.root.retrieve("/users/" + this.login + "/following", GHUser[].class);
        return new GHPersonSet<GHUser>((Collection<GHUser>)Arrays.asList(GHUser.wrap(followers, this.root)));
    }

    @WithBridgeMethods(value={Set.class})
    public GHPersonSet<GHUser> getFollowers() throws IOException {
        GHUser[] followers = this.root.retrieve("/users/" + this.login + "/followers", GHUser[].class);
        return new GHPersonSet<GHUser>((Collection<GHUser>)Arrays.asList(GHUser.wrap(followers, this.root)));
    }

    static GHUser[] wrap(GHUser[] users, GitHub root) {
        for (GHUser f : users) {
            f.root = root;
        }
        return users;
    }

    @WithBridgeMethods(value={Set.class})
    public GHPersonSet<GHOrganization> getOrganizations() throws IOException {
        GHPersonSet<GHOrganization> orgs = new GHPersonSet<GHOrganization>();
        HashSet<String> names = new HashSet<String>();
        for (GHOrganization o : this.root.retrieve("/users/" + this.login + "/orgs", GHOrganization[].class)) {
            if (!names.add(o.getLogin())) continue;
            orgs.add(this.root.getOrganization(o.getLogin()));
        }
        return orgs;
    }

    public String toString() {
        return "User:" + this.login;
    }

    public int hashCode() {
        return this.login.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GHUser) {
            GHUser that = (GHUser)obj;
            return this.login.equals(that.login);
        }
        return false;
    }
}

