/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.introspect.VisibilityChecker;
import org.kohsuke.github.GHEventInfo;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRateLimit;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.JsonRateLimit;
import org.kohsuke.github.Requester;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class GitHub {
    final String login;
    final String encodedAuthorization;
    final String password;
    final String apiToken;
    private final Map<String, GHUser> users = new HashMap<String, GHUser>();
    private final Map<String, GHOrganization> orgs = new HashMap<String, GHOrganization>();
    String oauthAccessToken;
    private final String githubServer;
    static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String[] TIME_FORMATS = new String[]{"yyyy/MM/dd HH:mm:ss ZZZZ", "yyyy-MM-dd'T'HH:mm:ss'Z'"};

    private GitHub(String login, String apiToken, String password) {
        this("github.com", login, apiToken, password);
    }

    private GitHub(String githubServer, String login, String apiToken, String password) {
        this.githubServer = githubServer;
        this.login = login;
        this.apiToken = apiToken;
        this.password = password;
        BASE64Encoder enc = new BASE64Encoder();
        if (apiToken != null || password != null) {
            String userpassword = password == null ? login + "/token" + ":" + apiToken : login + ':' + password;
            this.encodedAuthorization = enc.encode(userpassword.getBytes());
        } else {
            this.encodedAuthorization = null;
        }
    }

    private GitHub(String githubServer, String oauthAccessToken) throws IOException {
        this.githubServer = githubServer;
        this.password = null;
        this.encodedAuthorization = null;
        this.oauthAccessToken = oauthAccessToken;
        this.apiToken = oauthAccessToken;
        this.login = this.getMyself().getLogin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GitHub connect() throws IOException {
        Properties props = new Properties();
        File homeDir = new File(System.getProperty("user.home"));
        FileInputStream in = new FileInputStream(new File(homeDir, ".github"));
        try {
            props.load(in);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return new GitHub(props.getProperty("login"), props.getProperty("token"), props.getProperty("password"));
    }

    public static GitHub connect(String login, String apiToken) {
        return new GitHub(login, apiToken, null);
    }

    public static GitHub connect(String login, String apiToken, String password) {
        return new GitHub(login, apiToken, password);
    }

    public static GitHub connectUsingOAuth(String accessToken) throws IOException {
        return GitHub.connectUsingOAuth("github.com", accessToken);
    }

    public static GitHub connectUsingOAuth(String githubServer, String accessToken) throws IOException {
        return new GitHub(githubServer, accessToken);
    }

    public static GitHub connectAnonymously() {
        return new GitHub(null, null, null);
    }

    void requireCredential() {
        if ((this.login == null || this.encodedAuthorization == null) && this.oauthAccessToken == null) {
            throw new IllegalStateException("This operation requires a credential but none is given to the GitHub constructor");
        }
    }

    URL getApiURL(String tailApiUrl) throws IOException {
        if (this.oauthAccessToken != null) {
            tailApiUrl = tailApiUrl + (tailApiUrl.indexOf(63) >= 0 ? (char)'&' : '?') + "access_token=" + this.oauthAccessToken;
        }
        if (tailApiUrl.startsWith("/")) {
            return new URL("https://api." + this.githubServer + tailApiUrl);
        }
        return new URL(tailApiUrl);
    }

    Requester retrieve() {
        return new Requester(this).method("GET");
    }

    public GHRateLimit getRateLimit() throws IOException {
        return ((JsonRateLimit)((Object)this.retrieve().withCredential().to((String)"/rate_limit", JsonRateLimit.class))).rate;
    }

    @WithBridgeMethods(value={GHUser.class})
    public GHMyself getMyself() throws IOException {
        this.requireCredential();
        GHMyself u = (GHMyself)((Object)this.retrieve().withCredential().to("/user", GHMyself.class));
        u.root = this;
        this.users.put(u.getLogin(), u);
        return u;
    }

    public GHUser getUser(String login) throws IOException {
        GHUser u = this.users.get(login);
        if (u == null) {
            u = (GHUser)((Object)this.retrieve().to("/users/" + login, GHUser.class));
            u.root = this;
            this.users.put(u.getLogin(), u);
        }
        return u;
    }

    protected GHUser getUser(GHUser orig) throws IOException {
        GHUser u = this.users.get(orig.getLogin());
        if (u == null) {
            orig.root = this;
            this.users.put(this.login, orig);
            return orig;
        }
        return u;
    }

    public GHOrganization getOrganization(String name) throws IOException {
        GHOrganization o = this.orgs.get(name);
        if (o == null) {
            o = ((GHOrganization)((Object)this.retrieve().to("/orgs/" + name, GHOrganization.class))).wrapUp(this);
            this.orgs.put(name, o);
        }
        return o;
    }

    public GHRepository getRepository(String name) throws IOException {
        String[] tokens = name.split("/");
        return this.getUser(tokens[0]).getRepository(tokens[1]);
    }

    public Map<String, GHOrganization> getMyOrganizations() throws IOException {
        GHOrganization[] orgs = (GHOrganization[])this.retrieve().withCredential().to("/user/orgs", GHOrganization[].class);
        HashMap<String, GHOrganization> r = new HashMap<String, GHOrganization>();
        for (GHOrganization o : orgs) {
            r.put(o.getLogin(), o.wrapUp(this));
        }
        return r;
    }

    public List<GHEventInfo> getEvents() throws IOException {
        GHEventInfo[] events;
        for (GHEventInfo e : events = (GHEventInfo[])this.retrieve().to("/events", GHEventInfo[].class)) {
            e.wrapUp(this);
        }
        return Arrays.asList(events);
    }

    public <T extends GHEventPayload> T parseEventPayload(Reader r, Class<T> type) throws IOException {
        GHEventPayload t = (GHEventPayload)MAPPER.readValue(r, type);
        t.wrapUp(this);
        return (T)t;
    }

    public GHRepository createRepository(String name, String description, String homepage, boolean isPublic) throws IOException {
        Requester requester = new Requester(this).withCredential().with("name", name).with("description", description).with("homepage", homepage).with("public", isPublic ? 1 : 0);
        return ((GHRepository)((Object)requester.method("POST").to("/user/repos", GHRepository.class))).wrap(this);
    }

    public boolean isCredentialValid() throws IOException {
        try {
            this.retrieve().withCredential().to("/user", GHUser.class);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    WebClient createWebClient() throws IOException {
        WebClient wc = new WebClient();
        wc.setJavaScriptEnabled(false);
        wc.setCssEnabled(false);
        HtmlPage pg = (HtmlPage)wc.getPage("https://github.com/login");
        HtmlForm f = (HtmlForm)pg.getForms().get(0);
        f.getInputByName("login").setValueAttribute(this.login);
        f.getInputByName("password").setValueAttribute(this.password);
        f.submit();
        return wc;
    }

    static URL parseURL(String s) {
        try {
            return s == null ? null : new URL(s);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid URL: " + s);
        }
    }

    static Date parseDate(String timestamp) {
        if (timestamp == null) {
            return null;
        }
        for (String f : TIME_FORMATS) {
            try {
                SimpleDateFormat df = new SimpleDateFormat(f);
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                return df.parse(timestamp);
            }
            catch (ParseException e) {
            }
        }
        throw new IllegalStateException("Unable to parse the timestamp: " + timestamp);
    }

    static {
        MAPPER.setVisibilityChecker((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY));
        MAPPER.getDeserializationConfig().set(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

