/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nonnull;
import org.kohsuke.github.GHIOException;
import org.kohsuke.github.GitHubAbuseLimitHandler;
import org.kohsuke.github.HttpException;
import org.kohsuke.github.connector.GitHubConnectorResponse;

@Deprecated
public abstract class AbuseLimitHandler
extends GitHubAbuseLimitHandler {
    @Deprecated
    public static final AbuseLimitHandler WAIT = new AbuseLimitHandler(){

        @Override
        public void onError(IOException e, HttpURLConnection uc) throws IOException {
            try {
                Thread.sleep(this.parseWaitTime(uc));
            }
            catch (InterruptedException ex) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
        }
    };
    @Deprecated
    public static final AbuseLimitHandler FAIL = new AbuseLimitHandler(){

        @Override
        public void onError(IOException e, HttpURLConnection uc) throws IOException {
            throw e;
        }
    };

    @Override
    public void onError(@Nonnull GitHubConnectorResponse connectorResponse) throws IOException {
        GHIOException e = new HttpException("Abuse limit reached", connectorResponse.statusCode(), connectorResponse.header("Status"), connectorResponse.request().url().toString()).withResponseHeaderFields(connectorResponse.allHeaders());
        this.onError(e, connectorResponse.toHttpURLConnection());
    }

    @Deprecated
    public abstract void onError(IOException var1, HttpURLConnection var2) throws IOException;

    long parseWaitTime(HttpURLConnection uc) {
        String v = uc.getHeaderField("Retry-After");
        if (v == null) {
            return 61000L;
        }
        try {
            return Math.max(1000L, Long.parseLong(v) * 1000L);
        }
        catch (NumberFormatException nfe) {
            ZonedDateTime zdt = ZonedDateTime.parse(v, DateTimeFormatter.RFC_1123_DATE_TIME);
            return ChronoUnit.MILLIS.between(ZonedDateTime.now(), zdt);
        }
    }
}

