/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github.extras.authorization;

import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.io.Serializer;
import io.jsonwebtoken.jackson.io.JacksonSerializer;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import io.jsonwebtoken.security.SignatureAlgorithm;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Key;
import java.security.PrivateKey;
import java.time.Instant;
import java.util.Date;
import java.util.logging.Logger;
import org.kohsuke.github.GHException;

final class JwtBuilderUtil {
    private static final Logger LOGGER = Logger.getLogger(JwtBuilderUtil.class.getName());
    private static IJwtBuilder builder;

    JwtBuilderUtil() {
    }

    static String buildJwt(Instant issuedAt, Instant expiration, String applicationId, PrivateKey privateKey) {
        if (builder == null) {
            JwtBuilderUtil.createBuilderImpl(issuedAt, expiration, applicationId, privateKey);
        }
        return builder.buildJwt(issuedAt, expiration, applicationId, privateKey);
    }

    private static void createBuilderImpl(Instant issuedAt, Instant expiration, String applicationId, PrivateKey privateKey) {
        try {
            builder = new DefaultBuilderImpl();
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            LOGGER.warning("You are using an outdated version of the io.jsonwebtoken:jjwt-* suite. v0.12.x or later is recommended.");
            try {
                ReflectionBuilderImpl reflectionBuider = new ReflectionBuilderImpl();
                reflectionBuider.buildJwtWithReflection(issuedAt, expiration, applicationId, privateKey);
                builder = reflectionBuider;
            }
            catch (ReflectiveOperationException re) {
                throw new GHException("Could not build JWT using reflection on io.jsonwebtoken:jjwt-* suite.The minimum supported version is v0.11.x, v0.12.x or later is recommended.", re);
            }
        }
    }

    static interface IJwtBuilder {
        public String buildJwt(Instant var1, Instant var2, String var3, PrivateKey var4);
    }

    private static final class DefaultBuilderImpl
    implements IJwtBuilder {
        private DefaultBuilderImpl() {
        }

        @Override
        public String buildJwt(Instant issuedAt, Instant expiration, String applicationId, PrivateKey privateKey) {
            SignatureAlgorithm rs256 = Jwts.SIG.RS256;
            JwtBuilder jwtBuilder = Jwts.builder();
            jwtBuilder = jwtBuilder.issuedAt(Date.from(issuedAt)).expiration(Date.from(expiration)).issuer(applicationId).signWith((Key)privateKey, (SecureDigestAlgorithm)rs256).json((Serializer)new JacksonSerializer());
            return jwtBuilder.compact();
        }
    }

    private static final class ReflectionBuilderImpl
    implements IJwtBuilder {
        private Method setIssuedAtMethod;
        private Method setExpirationMethod;
        private Method setIssuerMethod;
        private Enum<?> rs256SignatureAlgorithm;
        private Method signWithMethod;
        private Method serializeToJsonMethod;

        ReflectionBuilderImpl() throws ReflectiveOperationException {
            JwtBuilder jwtBuilder = Jwts.builder();
            Class<?> jwtReflectionClass = jwtBuilder.getClass();
            this.setIssuedAtMethod = jwtReflectionClass.getMethod("setIssuedAt", Date.class);
            this.setIssuerMethod = jwtReflectionClass.getMethod("setIssuer", String.class);
            this.setExpirationMethod = jwtReflectionClass.getMethod("setExpiration", Date.class);
            Class<?> signatureAlgorithmClass = Class.forName("io.jsonwebtoken.SignatureAlgorithm");
            this.rs256SignatureAlgorithm = ReflectionBuilderImpl.createEnumInstance(signatureAlgorithmClass, "RS256");
            this.signWithMethod = jwtReflectionClass.getMethod("signWith", Key.class, signatureAlgorithmClass);
            this.serializeToJsonMethod = jwtReflectionClass.getMethod("serializeToJsonWith", Serializer.class);
        }

        @Override
        public String buildJwt(Instant issuedAt, Instant expiration, String applicationId, PrivateKey privateKey) {
            try {
                return this.buildJwtWithReflection(issuedAt, expiration, applicationId, privateKey);
            }
            catch (ReflectiveOperationException e) {
                throw new GHException("Reflection errors during JWT creation should have been checked already.", e);
            }
        }

        private String buildJwtWithReflection(Instant issuedAt, Instant expiration, String applicationId, PrivateKey privateKey) throws IllegalAccessException, InvocationTargetException {
            JwtBuilder jwtBuilder;
            Object builderObj = jwtBuilder = Jwts.builder();
            builderObj = this.setIssuedAtMethod.invoke(builderObj, Date.from(issuedAt));
            builderObj = this.setExpirationMethod.invoke(builderObj, Date.from(expiration));
            builderObj = this.setIssuerMethod.invoke(builderObj, applicationId);
            builderObj = this.signWithMethod.invoke(builderObj, privateKey, this.rs256SignatureAlgorithm);
            builderObj = this.serializeToJsonMethod.invoke(builderObj, new JacksonSerializer());
            return builderObj.compact();
        }

        private static <T extends Enum<T>> T createEnumInstance(Class<?> type, String name) {
            return (T)Enum.valueOf(type, name);
        }
    }
}

