/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.Date;
import org.codehaus.jackson.node.ObjectNode;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHEventInfo {
    private GitHub root;
    private ObjectNode payload;
    private String created_at;
    private String type;
    private GHEventRepository repo;
    private GHUser actor;
    private GHOrganization org;

    public GHEvent getType() {
        String t = this.type;
        if (t.endsWith("Event")) {
            t = t.substring(0, t.length() - 5);
        }
        for (GHEvent e : GHEvent.values()) {
            if (!e.name().replace("_", "").equalsIgnoreCase(t)) continue;
            return e;
        }
        return null;
    }

    GHEventInfo wrapUp(GitHub root) {
        this.root = root;
        return this;
    }

    public Date getCreatedAt() {
        return GitHub.parseDate(this.created_at);
    }

    public GHRepository getRepository() throws IOException {
        return this.root.getRepository(this.repo.name);
    }

    public GHUser getActor() throws IOException {
        return this.root.getUser(this.actor.getLogin());
    }

    public GHOrganization getOrganization() throws IOException {
        return this.org == null || this.org.getLogin() == null ? null : this.root.getOrganization(this.org.getLogin());
    }

    public <T extends GHEventPayload> T getPayload(Class<T> type) throws IOException {
        GHEventPayload v = (GHEventPayload)GitHub.MAPPER.readValue(this.payload.traverse(), type);
        v.wrapUp(this.root);
        return (T)v;
    }

    public static class GHEventRepository {
        private int id;
        private String url;
        private String name;
    }
}

