/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHTeam {
    private String name;
    private String permission;
    private int id;
    private GHOrganization organization;
    protected GHOrganization org;

    GHTeam wrapUp(GHOrganization owner) {
        this.org = owner;
        return this;
    }

    GHTeam wrapUp(GitHub root) {
        this.organization.wrapUp(root);
        return this.wrapUp(this.organization);
    }

    static GHTeam[] wrapUp(GHTeam[] teams, GHOrganization owner) {
        for (GHTeam t : teams) {
            t.wrapUp(owner);
        }
        return teams;
    }

    public String getName() {
        return this.name;
    }

    public String getPermission() {
        return this.permission;
    }

    public int getId() {
        return this.id;
    }

    public Set<GHUser> getMembers() throws IOException {
        return new HashSet<GHUser>(Arrays.asList(GHUser.wrap((GHUser[])this.org.root.retrieve().to(this.api("/members"), GHUser[].class), this.org.root)));
    }

    public boolean hasMember(GHUser user) {
        try {
            this.org.root.retrieve().to("/teams/" + this.id + "/members/" + user.getLogin());
            return true;
        }
        catch (IOException ignore) {
            return false;
        }
    }

    public Map<String, GHRepository> getRepositories() throws IOException {
        GHRepository[] repos = (GHRepository[])this.org.root.retrieve().to(this.api("/repos"), GHRepository[].class);
        TreeMap<String, GHRepository> m = new TreeMap<String, GHRepository>();
        for (GHRepository r : repos) {
            m.put(r.getName(), r.wrap(this.org.root));
        }
        return m;
    }

    public void add(GHUser u) throws IOException {
        this.org.root.retrieve().method("PUT").to(this.api("/members/" + u.getLogin()), null);
    }

    public void remove(GHUser u) throws IOException {
        this.org.root.retrieve().method("DELETE").to(this.api("/members/" + u.getLogin()), null);
    }

    public void add(GHRepository r) throws IOException {
        this.org.root.retrieve().method("PUT").to(this.api("/repos/" + r.getOwnerName() + '/' + r.getName()), null);
    }

    public void remove(GHRepository r) throws IOException {
        this.org.root.retrieve().method("DELETE").to(this.api("/repos/" + r.getOwnerName() + '/' + r.getName()), null);
    }

    private String api(String tail) {
        return "/teams/" + this.id + tail;
    }

    public GHOrganization getOrganization() {
        return this.org;
    }
}

