/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.PagedSearchIterable;
import org.kohsuke.github.Requester;
import org.kohsuke.github.SearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHIssueSearchBuilder {
    private final GitHub root;
    private final Requester req;
    private final List<String> terms = new ArrayList<String>();

    GHIssueSearchBuilder(GitHub root) {
        this.root = root;
        this.req = root.retrieve();
    }

    public GHIssueSearchBuilder q(String term) {
        this.terms.add(term);
        return this;
    }

    public GHIssueSearchBuilder mentions(GHUser u) {
        return this.mentions(u.getLogin());
    }

    public GHIssueSearchBuilder mentions(String login) {
        return this.q("mentions:" + login);
    }

    public GHIssueSearchBuilder isOpen() {
        return this.q("is:open");
    }

    public GHIssueSearchBuilder isClosed() {
        return this.q("is:closed");
    }

    public GHIssueSearchBuilder isMerged() {
        return this.q("is:merged");
    }

    public GHIssueSearchBuilder sort(Sort sort) {
        this.req.with("sort", sort.toString().toLowerCase(Locale.ENGLISH));
        return this;
    }

    public PagedSearchIterable<GHIssue> list() {
        return new PagedSearchIterable<GHIssue>(){

            @Override
            public PagedIterator<GHIssue> iterator() {
                GHIssueSearchBuilder.this.req.set("q", StringUtils.join((Collection)GHIssueSearchBuilder.this.terms, (String)" "));
                return new PagedIterator<GHIssue>(this.adapt(GHIssueSearchBuilder.this.req.asIterator("/search/issues", IssueSearchResult.class))){

                    protected void wrapUp(GHIssue[] page) {
                        for (GHIssue c : page) {
                            c.wrap(GHIssueSearchBuilder.this.root);
                        }
                    }
                };
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IssueSearchResult
    extends SearchResult<GHIssue> {
        private GHIssue[] items;

        private IssueSearchResult() {
        }

        public GHIssue[] getItems() {
            return this.items;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sort {
        COMMENTS,
        CREATED,
        UPDATED;

    }
}

