/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.HttpConnector;

public class GitHubBuilder {
    private String endpoint = "https://api.github.com";
    String user;
    String password;
    String oauthToken;
    private HttpConnector connector;

    public static GitHubBuilder fromCredentials() throws IOException {
        try {
            GitHubBuilder builder = GitHubBuilder.fromPropertyFile();
            if (builder.user != null) {
                return builder;
            }
            builder = GitHubBuilder.fromEnvironment();
            if (builder.user != null) {
                return builder;
            }
            throw new IOException("Failed to resolve credentials from ~/.github or the environment.");
        }
        catch (FileNotFoundException e) {
            GitHubBuilder builder = GitHubBuilder.fromEnvironment();
            if (builder.user != null) {
                return builder;
            }
            throw new IOException("Failed to resolve credentials from ~/.github or the environment.", e);
        }
    }

    public static GitHubBuilder fromEnvironment(String loginVariableName, String passwordVariableName, String oauthVariableName) throws IOException {
        String oauthValue;
        String passwordValue;
        Properties env = new Properties();
        String loginValue = System.getenv(loginVariableName);
        if (loginValue != null) {
            env.put("login", loginValue);
        }
        if ((passwordValue = System.getenv(passwordVariableName)) != null) {
            env.put("password", passwordValue);
        }
        if ((oauthValue = System.getenv(oauthVariableName)) != null) {
            env.put("oauth", oauthValue);
        }
        return GitHubBuilder.fromProperties(env);
    }

    public static GitHubBuilder fromEnvironment() throws IOException {
        Properties props = new Properties();
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> element : env.entrySet()) {
            props.put(element.getKey(), element.getValue());
        }
        return GitHubBuilder.fromProperties(props);
    }

    public static GitHubBuilder fromPropertyFile() throws IOException {
        File homeDir = new File(System.getProperty("user.home"));
        File propertyFile = new File(homeDir, ".github");
        return GitHubBuilder.fromPropertyFile(propertyFile.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GitHubBuilder fromPropertyFile(String propertyFileName) throws IOException {
        Properties props = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(propertyFileName);
            props.load(in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return GitHubBuilder.fromProperties(props);
    }

    public static GitHubBuilder fromProperties(Properties props) {
        GitHubBuilder self = new GitHubBuilder();
        self.withOAuthToken(props.getProperty("oauth"), props.getProperty("login"));
        self.withPassword(props.getProperty("login"), props.getProperty("password"));
        return self;
    }

    public GitHubBuilder withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public GitHubBuilder withPassword(String user, String password) {
        this.user = user;
        this.password = password;
        return this;
    }

    public GitHubBuilder withOAuthToken(String oauthToken) {
        return this.withOAuthToken(oauthToken, null);
    }

    public GitHubBuilder withOAuthToken(String oauthToken, String user) {
        this.oauthToken = oauthToken;
        this.user = user;
        return this;
    }

    public GitHubBuilder withConnector(HttpConnector connector) {
        this.connector = connector;
        return this;
    }

    public GitHubBuilder withProxy(final Proxy p) {
        return this.withConnector(new HttpConnector(){

            public HttpURLConnection connect(URL url) throws IOException {
                return (HttpURLConnection)url.openConnection(p);
            }
        });
    }

    public GitHub build() throws IOException {
        return new GitHub(this.endpoint, this.user, this.oauthToken, this.password, this.connector);
    }
}

