/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import java.net.URL;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitUser;

public class GHPullRequestCommitDetail {
    private GHPullRequest owner;
    String sha;
    Commit commit;
    String url;
    String html_url;
    String comments_url;
    CommitPointer[] parents;

    void wrapUp(GHPullRequest owner) {
        this.owner = owner;
    }

    public String getSha() {
        return this.sha;
    }

    public Commit getCommit() {
        return this.commit;
    }

    public URL getApiUrl() {
        return GitHub.parseURL(this.url);
    }

    public URL getUrl() {
        return GitHub.parseURL(this.html_url);
    }

    public URL getCommentsUrl() {
        return GitHub.parseURL(this.comments_url);
    }

    public CommitPointer[] getParents() {
        return this.parents;
    }

    public static class CommitPointer {
        String sha;
        String url;
        String html_url;

        public URL getUrl() {
            return GitHub.parseURL(this.url);
        }

        public URL getHtml_url() {
            return GitHub.parseURL(this.html_url);
        }

        public String getSha() {
            return this.sha;
        }
    }

    @BridgeMethodsAdded
    public static class Commit {
        Authorship author;
        Authorship committer;
        String message;
        Tree tree;
        String url;
        int comment_count;

        @WithBridgeMethods(value={Authorship.class}, castRequired=true)
        public GitUser getAuthor() {
            return this.author;
        }

        @WithBridgeMethods(value={Authorship.class}, castRequired=true)
        public GitUser getCommitter() {
            return this.committer;
        }

        public String getMessage() {
            return this.message;
        }

        public URL getUrl() {
            return GitHub.parseURL(this.url);
        }

        public int getComment_count() {
            return this.comment_count;
        }
    }

    public static class Tree {
        String sha;
        String url;

        public String getSha() {
            return this.sha;
        }

        public URL getUrl() {
            return GitHub.parseURL(this.url);
        }
    }

    public static class Authorship
    extends GitUser {
    }
}

