/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Iterator;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.SearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="Constructed by JSON API")
public abstract class PagedSearchIterable<T>
extends PagedIterable<T> {
    private final GitHub root;
    private SearchResult<T> result;

    PagedSearchIterable(GitHub root) {
        this.root = root;
    }

    @Override
    public PagedSearchIterable<T> withPageSize(int size) {
        return (PagedSearchIterable)super.withPageSize(size);
    }

    public int getTotalCount() {
        this.populate();
        return this.result.total_count;
    }

    public boolean isIncomplete() {
        this.populate();
        return this.result.incomplete_results;
    }

    private void populate() {
        if (this.result == null) {
            ((PagedIterator)this.iterator()).hasNext();
        }
    }

    protected Iterator<T[]> adapt(final Iterator<? extends SearchResult<T>> base) {
        return new Iterator<T[]>(){

            @Override
            public boolean hasNext() {
                return base.hasNext();
            }

            @Override
            public T[] next() {
                SearchResult v = (SearchResult)base.next();
                if (PagedSearchIterable.this.result == null) {
                    PagedSearchIterable.this.result = v;
                }
                return v.getItems(PagedSearchIterable.this.root);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

