/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import org.kohsuke.github.GHCommitPointer;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHPullRequestCommitDetail;
import org.kohsuke.github.GHPullRequestFileDetail;
import org.kohsuke.github.GHPullRequestReviewComment;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.Requester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHPullRequest
extends GHIssue {
    private String patch_url;
    private String diff_url;
    private String issue_url;
    private GHCommitPointer base;
    private String merged_at;
    private GHCommitPointer head;
    private GHUser merged_by;
    private int review_comments;
    private int additions;
    private boolean merged;
    private Boolean mergeable;
    private int deletions;
    private String mergeable_state;
    private int changed_files;
    private String merge_commit_sha;
    private transient boolean fetchedIssueDetails;

    GHPullRequest wrapUp(GHRepository owner) {
        this.wrap(owner);
        return this.wrapUp(owner.root);
    }

    GHPullRequest wrapUp(GitHub root) {
        if (this.owner != null) {
            this.owner.wrap(root);
        }
        if (this.base != null) {
            this.base.wrapUp(root);
        }
        if (this.head != null) {
            this.head.wrapUp(root);
        }
        if (this.merged_by != null) {
            this.merged_by.wrapUp(root);
        }
        return this;
    }

    @Override
    protected String getApiRoute() {
        return "/repos/" + this.owner.getOwnerName() + "/" + this.owner.getName() + "/pulls/" + this.number;
    }

    public URL getPatchUrl() {
        return GitHub.parseURL(this.patch_url);
    }

    public URL getIssueUrl() {
        return GitHub.parseURL(this.issue_url);
    }

    public GHCommitPointer getBase() {
        return this.base;
    }

    public GHCommitPointer getHead() {
        return this.head;
    }

    @Deprecated
    public Date getIssueUpdatedAt() throws IOException {
        return super.getUpdatedAt();
    }

    public URL getDiffUrl() {
        return GitHub.parseURL(this.diff_url);
    }

    public Date getMergedAt() {
        return GitHub.parseDate(this.merged_at);
    }

    @Override
    public Collection<GHLabel> getLabels() throws IOException {
        this.fetchIssue();
        return super.getLabels();
    }

    @Override
    public GHUser getClosedBy() {
        return null;
    }

    @Override
    public GHIssue.PullRequest getPullRequest() {
        return null;
    }

    public GHUser getMergedBy() throws IOException {
        this.populate();
        return this.merged_by;
    }

    public int getReviewComments() throws IOException {
        this.populate();
        return this.review_comments;
    }

    public int getAdditions() throws IOException {
        this.populate();
        return this.additions;
    }

    public boolean isMerged() throws IOException {
        this.populate();
        return this.merged;
    }

    public Boolean getMergeable() throws IOException {
        this.populate();
        return this.mergeable;
    }

    public int getDeletions() throws IOException {
        this.populate();
        return this.deletions;
    }

    public String getMergeableState() throws IOException {
        this.populate();
        return this.mergeable_state;
    }

    public int getChangedFiles() throws IOException {
        this.populate();
        return this.changed_files;
    }

    public String getMergeCommitSha() throws IOException {
        this.populate();
        return this.merge_commit_sha;
    }

    private void populate() throws IOException {
        if (this.merged_by != null) {
            return;
        }
        if (this.root.isOffline()) {
            return;
        }
        this.root.retrieve().to(this.url, this).wrapUp(this.owner);
    }

    public PagedIterable<GHPullRequestFileDetail> listFiles() {
        return new PagedIterable<GHPullRequestFileDetail>(){

            @Override
            public PagedIterator<GHPullRequestFileDetail> _iterator(int pageSize) {
                return new PagedIterator<GHPullRequestFileDetail>(GHPullRequest.this.root.retrieve().asIterator(String.format("%s/files", GHPullRequest.this.getApiURL()), GHPullRequestFileDetail[].class, pageSize)){

                    protected void wrapUp(GHPullRequestFileDetail[] page) {
                    }
                };
            }
        };
    }

    public PagedIterable<GHPullRequestReviewComment> listReviewComments() throws IOException {
        return new PagedIterable<GHPullRequestReviewComment>(){

            @Override
            public PagedIterator<GHPullRequestReviewComment> _iterator(int pageSize) {
                return new PagedIterator<GHPullRequestReviewComment>(GHPullRequest.this.root.retrieve().asIterator(GHPullRequest.this.getApiRoute() + "/comments", GHPullRequestReviewComment[].class, pageSize)){

                    protected void wrapUp(GHPullRequestReviewComment[] page) {
                        for (GHPullRequestReviewComment c : page) {
                            c.wrapUp(GHPullRequest.this);
                        }
                    }
                };
            }
        };
    }

    public PagedIterable<GHPullRequestCommitDetail> listCommits() {
        return new PagedIterable<GHPullRequestCommitDetail>(){

            @Override
            public PagedIterator<GHPullRequestCommitDetail> _iterator(int pageSize) {
                return new PagedIterator<GHPullRequestCommitDetail>(GHPullRequest.this.root.retrieve().asIterator(String.format("%s/commits", GHPullRequest.this.getApiURL()), GHPullRequestCommitDetail[].class, pageSize)){

                    protected void wrapUp(GHPullRequestCommitDetail[] page) {
                        for (GHPullRequestCommitDetail c : page) {
                            c.wrapUp(GHPullRequest.this);
                        }
                    }
                };
            }
        };
    }

    public GHPullRequestReviewComment createReviewComment(String body, String sha, String path, int position) throws IOException {
        return ((GHPullRequestReviewComment)((Object)new Requester(this.root).method("POST").with("body", body).with("commit_id", sha).with("path", path).with("position", position).to(this.getApiRoute() + "/comments", GHPullRequestReviewComment.class))).wrapUp(this);
    }

    public void merge(String msg) throws IOException {
        this.merge(msg, null);
    }

    public void merge(String msg, String sha) throws IOException {
        new Requester(this.root).method("PUT").with("commit_message", msg).with("sha", sha).to(this.getApiRoute() + "/merge");
    }

    private void fetchIssue() throws IOException {
        if (!this.fetchedIssueDetails) {
            new Requester(this.root).to(this.getIssuesApiRoute(), this);
            this.fetchedIssueDetails = true;
        }
    }
}

