/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestReviewComment;
import org.kohsuke.github.GHPullRequestReviewState;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Requester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHPullRequestReview
extends GHObject {
    GHPullRequest owner;
    private String body;
    private GHUser user;
    private String commit_id;
    private GHPullRequestReviewState state;

    GHPullRequestReview wrapUp(GHPullRequest owner) {
        this.owner = owner;
        return this;
    }

    public GHPullRequest getParent() {
        return this.owner;
    }

    public String getBody() {
        return this.body;
    }

    public GHUser getUser() throws IOException {
        return this.owner.root.getUser(this.user.getLogin());
    }

    public String getCommitId() {
        return this.commit_id;
    }

    public GHPullRequestReviewState getState() {
        return this.state;
    }

    @Override
    public URL getHtmlUrl() {
        return null;
    }

    protected String getApiRoute() {
        return this.owner.getApiRoute() + "/reviews/" + this.id;
    }

    @Preview
    @Deprecated
    public void submit(String body, GHPullRequestReviewState event) throws IOException {
        new Requester(this.owner.root).method("POST").with("body", body).with("event", event.action()).withPreview("application/vnd.github.black-cat-preview+json").to(this.getApiRoute() + "/events", this);
        this.body = body;
        this.state = event;
    }

    @Preview
    @Deprecated
    public void delete() throws IOException {
        new Requester(this.owner.root).method("DELETE").withPreview("application/vnd.github.black-cat-preview+json").to(this.getApiRoute());
    }

    @Preview
    @Deprecated
    public void dismiss(String message) throws IOException {
        new Requester(this.owner.root).method("PUT").with("message", message).withPreview("application/vnd.github.black-cat-preview+json").to(this.getApiRoute() + "/dismissals");
        this.state = GHPullRequestReviewState.DISMISSED;
    }

    @Preview
    @Deprecated
    public PagedIterable<GHPullRequestReviewComment> listReviewComments() throws IOException {
        return new PagedIterable<GHPullRequestReviewComment>(){

            @Override
            public PagedIterator<GHPullRequestReviewComment> _iterator(int pageSize) {
                return new PagedIterator<GHPullRequestReviewComment>(GHPullRequestReview.this.owner.root.retrieve().withPreview("application/vnd.github.black-cat-preview+json").asIterator(GHPullRequestReview.this.getApiRoute() + "/comments", GHPullRequestReviewComment[].class, pageSize)){

                    protected void wrapUp(GHPullRequestReviewComment[] page) {
                        for (GHPullRequestReviewComment c : page) {
                            c.wrapUp(GHPullRequestReview.this.owner);
                        }
                    }
                };
            }
        };
    }
}

