/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.annotation.CheckForNull;
import javax.annotation.WillClose;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.github.GHFileNotFoundException;
import org.kohsuke.github.GHIOException;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHRateLimit;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.HttpException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Requester {
    private final GitHub root;
    private final List<Entry> args = new ArrayList<Entry>();
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private String method = "POST";
    private String contentType = null;
    private InputStream body;
    private HttpURLConnection uc;
    private boolean forceBody;
    private static final List<String> METHODS_WITHOUT_BODY = Arrays.asList("GET", "DELETE");
    private static final Logger LOGGER = Logger.getLogger(Requester.class.getName());

    Requester(GitHub root) {
        this.root = root;
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public Requester withHeader(String name, String value) {
        this.setHeader(name, value);
        return this;
    }

    Requester withPreview(String name) {
        return this.withHeader("Accept", name);
    }

    @Deprecated
    public Requester withCredential() {
        return this;
    }

    public Requester with(String key, int value) {
        return this._with(key, value);
    }

    public Requester with(String key, Integer value) {
        if (value != null) {
            this._with(key, value);
        }
        return this;
    }

    public Requester with(String key, boolean value) {
        return this._with(key, value);
    }

    public Requester with(String key, Boolean value) {
        return this._with(key, value);
    }

    public Requester with(String key, Enum e) {
        if (e == null) {
            return this._with(key, null);
        }
        return this.with(key, e.toString().toLowerCase(Locale.ENGLISH).replace('_', '-'));
    }

    public Requester with(String key, String value) {
        return this._with(key, value);
    }

    public Requester with(String key, Collection<String> value) {
        return this._with(key, value);
    }

    public Requester with(String key, Map<String, String> value) {
        return this._with(key, value);
    }

    public Requester with(@WillClose InputStream body) {
        this.body = body;
        return this;
    }

    public Requester withNullable(String key, Object value) {
        this.args.add(new Entry(key, value));
        return this;
    }

    public Requester _with(String key, Object value) {
        if (value != null) {
            this.args.add(new Entry(key, value));
        }
        return this;
    }

    public Requester set(String key, Object value) {
        for (Entry e : this.args) {
            if (!e.key.equals(key)) continue;
            e.value = value;
            return this;
        }
        return this._with(key, value);
    }

    public Requester method(String method) {
        this.method = method;
        return this;
    }

    public Requester contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    Requester inBody() {
        this.forceBody = true;
        return this;
    }

    public void to(String tailApiUrl) throws IOException {
        this.to(tailApiUrl, (Object)null);
    }

    public <T> T to(String tailApiUrl, Class<T> type) throws IOException {
        return this._to(tailApiUrl, type, null);
    }

    public <T> T to(String tailApiUrl, T existingInstance) throws IOException {
        return this._to(tailApiUrl, null, existingInstance);
    }

    @Deprecated
    public <T> T to(String tailApiUrl, Class<T> type, String method) throws IOException {
        return (T)this.method(method).to(tailApiUrl, (T)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SBSC_USE_STRINGBUFFER_CONCATENATION"})
    private <T> T _to(String tailApiUrl, Class<T> type, T instance) throws IOException {
        if (!this.isMethodWithBody() && !this.args.isEmpty()) {
            boolean questionMarkFound = tailApiUrl.indexOf(63) != -1;
            tailApiUrl = tailApiUrl + (questionMarkFound ? (char)'&' : '?');
            ListIterator<Entry> it = this.args.listIterator();
            while (it.hasNext()) {
                Entry arg = (Entry)it.next();
                tailApiUrl = tailApiUrl + arg.key + '=' + URLEncoder.encode(arg.value.toString(), "UTF-8");
                if (!it.hasNext()) continue;
                tailApiUrl = tailApiUrl + '&';
            }
        }
        while (true) {
            this.setupConnection(this.root.getApiURL(tailApiUrl));
            this.buildRequest();
            try {
                Pattern nextLinkPattern;
                Matcher nextLinkMatcher;
                String links;
                Object result = this.parse(type, instance);
                if (type != null && type.isArray() && (links = this.uc.getHeaderField("link")) != null && links.contains("rel=\"next\"") && (nextLinkMatcher = (nextLinkPattern = Pattern.compile(".*<(.*)>; rel=\"next\"")).matcher(links)).find()) {
                    String link = nextLinkMatcher.group(1);
                    T nextResult = this._to(link, type, instance);
                    this.setResponseHeaders(nextResult);
                    int resultLength = Array.getLength(result);
                    int nextResultLength = Array.getLength(nextResult);
                    Object concatResult = Array.newInstance(type.getComponentType(), resultLength + nextResultLength);
                    System.arraycopy(result, 0, concatResult, 0, resultLength);
                    System.arraycopy(nextResult, 0, concatResult, resultLength, nextResultLength);
                    result = concatResult;
                }
                T t = this.setResponseHeaders(result);
                return t;
            }
            catch (IOException e) {
                this.handleApiError(e);
                continue;
            }
            finally {
                this.noteRateLimit(tailApiUrl);
                continue;
            }
            break;
        }
    }

    public int asHttpStatusCode(String tailApiUrl) throws IOException {
        while (true) {
            this.method("GET");
            this.setupConnection(this.root.getApiURL(tailApiUrl));
            this.buildRequest();
            try {
                int n = this.uc.getResponseCode();
                return n;
            }
            catch (IOException e) {
                this.handleApiError(e);
                continue;
            }
            finally {
                this.noteRateLimit(tailApiUrl);
                continue;
            }
            break;
        }
    }

    public InputStream asStream(String tailApiUrl) throws IOException {
        while (true) {
            this.setupConnection(this.root.getApiURL(tailApiUrl));
            this.buildRequest();
            try {
                InputStream inputStream = this.wrapStream(this.uc.getInputStream());
                return inputStream;
            }
            catch (IOException e) {
                this.handleApiError(e);
                continue;
            }
            finally {
                this.noteRateLimit(tailApiUrl);
                continue;
            }
            break;
        }
    }

    private void noteRateLimit(String tailApiUrl) {
        block13: {
            if ("/rate_limit".equals(tailApiUrl)) {
                return;
            }
            if (tailApiUrl.startsWith("/search")) {
                return;
            }
            String limit = this.uc.getHeaderField("X-RateLimit-Limit");
            if (StringUtils.isBlank((String)limit)) {
                return;
            }
            String remaining = this.uc.getHeaderField("X-RateLimit-Remaining");
            if (StringUtils.isBlank((String)remaining)) {
                return;
            }
            String reset = this.uc.getHeaderField("X-RateLimit-Reset");
            if (StringUtils.isBlank((String)reset)) {
                return;
            }
            GHRateLimit observed = new GHRateLimit();
            try {
                observed.limit = Integer.parseInt(limit);
            }
            catch (NumberFormatException e) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Malformed X-RateLimit-Limit header value " + limit, e);
                }
                return;
            }
            try {
                observed.remaining = Integer.parseInt(remaining);
            }
            catch (NumberFormatException e) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Malformed X-RateLimit-Remaining header value " + remaining, e);
                }
                return;
            }
            try {
                observed.reset = new Date(Long.parseLong(reset));
                this.root.updateRateLimit(observed);
            }
            catch (NumberFormatException e) {
                if (!LOGGER.isLoggable(Level.FINEST)) break block13;
                LOGGER.log(Level.FINEST, "Malformed X-RateLimit-Reset header value " + reset, e);
            }
        }
    }

    public String getResponseHeader(String header) {
        return this.uc.getHeaderField(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildRequest() throws IOException {
        if (this.isMethodWithBody()) {
            this.uc.setDoOutput(true);
            if (this.body == null) {
                this.uc.setRequestProperty("Content-type", StringUtils.defaultString((String)this.contentType, (String)"application/json"));
                HashMap<String, Object> json = new HashMap<String, Object>();
                for (Entry e : this.args) {
                    json.put(e.key, e.value);
                }
                GitHub.MAPPER.writeValue(this.uc.getOutputStream(), json);
            } else {
                this.uc.setRequestProperty("Content-type", StringUtils.defaultString((String)this.contentType, (String)"application/x-www-form-urlencoded"));
                try {
                    int read;
                    byte[] bytes = new byte[32768];
                    while ((read = this.body.read(bytes)) != -1) {
                        this.uc.getOutputStream().write(bytes, 0, read);
                    }
                }
                finally {
                    this.body.close();
                }
            }
        }
    }

    private boolean isMethodWithBody() {
        return this.forceBody || !METHODS_WITHOUT_BODY.contains(this.method);
    }

    <T> Iterator<T> asIterator(String tailApiUrl, Class<T> type, int pageSize) {
        this.method("GET");
        if (pageSize != 0) {
            this.args.add(new Entry("per_page", pageSize));
        }
        StringBuilder s = new StringBuilder(tailApiUrl);
        if (!this.args.isEmpty()) {
            boolean first = true;
            try {
                for (Entry a : this.args) {
                    s.append(first ? (char)'?' : '&');
                    first = false;
                    s.append(URLEncoder.encode(a.key, "UTF-8"));
                    s.append('=');
                    s.append(URLEncoder.encode(a.value.toString(), "UTF-8"));
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }
        try {
            return new PagingIterator<T>(type, tailApiUrl, this.root.getApiURL(s.toString()));
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private void setupConnection(URL url) throws IOException {
        this.uc = this.root.getConnector().connect(url);
        if (this.root.encodedAuthorization != null) {
            this.uc.setRequestProperty("Authorization", this.root.encodedAuthorization);
        }
        for (Map.Entry<String, String> e : this.headers.entrySet()) {
            String v = e.getValue();
            if (v == null) continue;
            this.uc.setRequestProperty(e.getKey(), v);
        }
        this.setRequestMethod(this.uc);
        this.uc.setRequestProperty("Accept-Encoding", "gzip");
    }

    private void setRequestMethod(HttpURLConnection uc) throws IOException {
        try {
            uc.setRequestMethod(this.method);
        }
        catch (ProtocolException e) {
            try {
                Field $method = HttpURLConnection.class.getDeclaredField("method");
                $method.setAccessible(true);
                $method.set(uc, this.method);
            }
            catch (Exception x) {
                throw (IOException)new IOException("Failed to set the custom verb").initCause(x);
            }
            try {
                Field $delegate = uc.getClass().getDeclaredField("delegate");
                $delegate.setAccessible(true);
                Object delegate = $delegate.get(uc);
                if (delegate instanceof HttpURLConnection) {
                    HttpURLConnection nested = (HttpURLConnection)delegate;
                    this.setRequestMethod(nested);
                }
            }
            catch (NoSuchFieldException $delegate) {
            }
            catch (IllegalAccessException x) {
                throw (IOException)new IOException("Failed to set the custom verb").initCause(x);
            }
        }
        if (!uc.getRequestMethod().equals(this.method)) {
            throw new IllegalStateException("Failed to set the request method to " + this.method);
        }
    }

    @CheckForNull
    private <T> T parse(Class<T> type, T instance) throws IOException {
        return this.parse(type, instance, 2);
    }

    /*
     * Exception decompiling
     */
    private <T> T parse(Class<T> type, T instance, int timeouts) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 14[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <T> T setResponseHeaders(T readValue) {
        if (readValue instanceof GHObject[]) {
            for (GHObject ghObject : (GHObject[])readValue) {
                this.setResponseHeaders(ghObject);
            }
        } else if (readValue instanceof GHObject) {
            this.setResponseHeaders((GHObject)readValue);
        }
        return readValue;
    }

    private void setResponseHeaders(GHObject readValue) {
        readValue.responseHeaderFields = this.uc.getHeaderFields();
    }

    private InputStream wrapStream(InputStream in) throws IOException {
        String encoding = this.uc.getContentEncoding();
        if (encoding == null || in == null) {
            return in;
        }
        if (encoding.equals("gzip")) {
            return new GZIPInputStream(in);
        }
        throw new UnsupportedOperationException("Unexpected Content-Encoding: " + encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleApiError(IOException e) throws IOException {
        int responseCode;
        try {
            responseCode = this.uc.getResponseCode();
        }
        catch (IOException e2) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Silently ignore exception retrieving response code for '" + this.uc.getURL() + "' handling exception " + e, e);
            }
            throw e;
        }
        InputStream es = this.wrapStream(this.uc.getErrorStream());
        if (es != null) {
            try {
                String error = IOUtils.toString((InputStream)es, (String)"UTF-8");
                if (e instanceof FileNotFoundException) {
                    e = (IOException)new GHFileNotFoundException(error).withResponseHeaderFields(this.uc).initCause(e);
                } else if (e instanceof HttpException) {
                    HttpException http = (HttpException)e;
                    e = new HttpException(error, http.getResponseCode(), http.getResponseMessage(), http.getUrl(), e);
                } else {
                    e = (IOException)new GHIOException(error).withResponseHeaderFields(this.uc).initCause(e);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)es);
            }
        }
        if (responseCode == 401) {
            throw e;
        }
        if ("0".equals(this.uc.getHeaderField("X-RateLimit-Remaining"))) {
            this.root.rateLimitHandler.onError(e, this.uc);
            return;
        }
        if (responseCode == 403 && this.uc.getHeaderField("Retry-After") != null) {
            this.root.abuseLimitHandler.onError(e, this.uc);
            return;
        }
        throw e;
    }

    static /* synthetic */ void access$100(Requester x0, URL x1) throws IOException {
        x0.setupConnection(x1);
    }

    static /* synthetic */ Object access$200(Requester x0, Class x1, Object x2) throws IOException {
        return x0.parse(x1, x2);
    }

    static /* synthetic */ void access$300(Requester x0, String x1) {
        x0.noteRateLimit(x1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PagingIterator<T>
    implements Iterator<T> {
        private final Class<T> type;
        private final String tailApiUrl;
        private T next;
        private URL url;

        PagingIterator(Class<T> type, String tailApiUrl, URL url) {
            this.type = type;
            this.tailApiUrl = tailApiUrl;
            this.url = url;
        }

        @Override
        public boolean hasNext() {
            this.fetch();
            return this.next != null;
        }

        @Override
        public T next() {
            this.fetch();
            T r = this.next;
            if (r == null) {
                throw new NoSuchElementException();
            }
            this.next = null;
            return r;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * Unable to fully structure code
         */
        private void fetch() {
            if (this.next != null) {
                return;
            }
            if (this.url == null) {
                return;
            }
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    Requester.access$100(Requester.this, this.url);
                    try {
                        this.next = Requester.access$200(Requester.this, this.type, null);
                        if (!PagingIterator.$assertionsDisabled && this.next == null) {
                            throw new AssertionError();
                        }
                        this.findNextURL();
                        return;
                    }
                    catch (IOException e) {
                        Requester.this.handleApiError(e);
                    }
                    finally {
                        Requester.access$300(Requester.this, this.tailApiUrl);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                throw new Error(e);
            }
            ** GOTO lbl-1000
        }

        private void findNextURL() throws MalformedURLException {
            this.url = null;
            String link = Requester.this.uc.getHeaderField("Link");
            if (link == null) {
                return;
            }
            for (String token : link.split(", ")) {
                if (!token.endsWith("rel=\"next\"")) continue;
                int idx = token.indexOf(62);
                this.url = new URL(token.substring(1, idx));
                return;
            }
        }
    }

    private static class Entry {
        String key;
        Object value;

        private Entry(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

