/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.Requester;

public class GHReleaseBuilder {
    private final GHRepository repo;
    private final Requester builder;

    public GHReleaseBuilder(GHRepository ghRepository, String tag) {
        this.repo = ghRepository;
        this.builder = new Requester(this.repo.root);
        this.builder.with("tag_name", tag);
    }

    public GHReleaseBuilder body(String body) {
        this.builder.with("body", body);
        return this;
    }

    public GHReleaseBuilder commitish(String commitish) {
        this.builder.with("target_commitish", commitish);
        return this;
    }

    public GHReleaseBuilder draft(boolean draft) {
        this.builder.with("draft", draft);
        return this;
    }

    public GHReleaseBuilder name(String name) {
        this.builder.with("name", name);
        return this;
    }

    public GHReleaseBuilder prerelease(boolean prerelease) {
        this.builder.with("prerelease", prerelease);
        return this;
    }

    public GHRelease create() throws IOException {
        return ((GHRelease)((Object)this.builder.to(this.repo.getApiTailUrl("releases"), GHRelease.class))).wrap(this.repo);
    }
}

