/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Requester;

public class GHAsset
extends GHObject {
    GitHub root;
    GHRepository owner;
    private String name;
    private String label;
    private String state;
    private String content_type;
    private long size;
    private long download_count;
    private String browser_download_url;

    public String getContentType() {
        return this.content_type;
    }

    public void setContentType(String contentType) throws IOException {
        this.edit("content_type", contentType);
        this.content_type = contentType;
    }

    public long getDownloadCount() {
        return this.download_count;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) throws IOException {
        this.edit("label", label);
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public GHRepository getOwner() {
        return this.owner;
    }

    public GitHub getRoot() {
        return this.root;
    }

    public long getSize() {
        return this.size;
    }

    public String getState() {
        return this.state;
    }

    @Override
    public URL getHtmlUrl() {
        return null;
    }

    public String getBrowserDownloadUrl() {
        return this.browser_download_url;
    }

    private void edit(String key, Object value) throws IOException {
        new Requester(this.root)._with(key, value).method("PATCH").to(this.getApiRoute());
    }

    public void delete() throws IOException {
        new Requester(this.root).method("DELETE").to(this.getApiRoute());
    }

    private String getApiRoute() {
        return "/repos/" + this.owner.getOwnerName() + "/" + this.owner.getName() + "/releases/assets/" + this.id;
    }

    GHAsset wrap(GHRelease release) {
        this.owner = release.getOwner();
        this.root = this.owner.root;
        return this;
    }

    public static GHAsset[] wrap(GHAsset[] assets, GHRelease release) {
        for (GHAsset aTo : assets) {
            aTo.wrap(release);
        }
        return assets;
    }
}

