/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.github.GHEmail;
import org.kohsuke.github.GHKey;
import org.kohsuke.github.GHMembership;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHPersonSet;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GHVerifiedKey;
import org.kohsuke.github.PagedIterable;

public class GHMyself
extends GHUser {
    public List<String> getEmails() throws IOException {
        List<GHEmail> src = this.getEmails2();
        ArrayList<String> r = new ArrayList<String>(src.size());
        for (GHEmail e : src) {
            r.add(e.getEmail());
        }
        return r;
    }

    public List<GHEmail> getEmails2() throws IOException {
        GHEmail[] addresses = (GHEmail[])this.root.retrieve().to("/user/emails", GHEmail[].class);
        return Collections.unmodifiableList(Arrays.asList(addresses));
    }

    public List<GHKey> getPublicKeys() throws IOException {
        return Collections.unmodifiableList(Arrays.asList((Object[])this.root.retrieve().to("/user/keys", GHKey[].class)));
    }

    public List<GHVerifiedKey> getPublicVerifiedKeys() throws IOException {
        return Collections.unmodifiableList(Arrays.asList((Object[])this.root.retrieve().to("/users/" + this.getLogin() + "/keys", GHVerifiedKey[].class)));
    }

    public GHPersonSet<GHOrganization> getAllOrganizations() throws IOException {
        GHPersonSet<GHOrganization> orgs = new GHPersonSet<GHOrganization>();
        HashSet<String> names = new HashSet<String>();
        for (GHOrganization o : (GHOrganization[])this.root.retrieve().to("/user/orgs", GHOrganization[].class)) {
            if (!names.add(o.getLogin())) continue;
            orgs.add(this.root.getOrganization(o.getLogin()));
        }
        return orgs;
    }

    public synchronized Map<String, GHRepository> getAllRepositories() throws IOException {
        TreeMap<String, GHRepository> repositories = new TreeMap<String, GHRepository>();
        for (GHRepository r : this.listAllRepositories()) {
            repositories.put(r.getName(), r);
        }
        return Collections.unmodifiableMap(repositories);
    }

    @Override
    public PagedIterable<GHRepository> listRepositories() {
        return this.listRepositories(30);
    }

    @Override
    public PagedIterable<GHRepository> listRepositories(int pageSize) {
        return this.listRepositories(pageSize, RepositoryListFilter.ALL);
    }

    public PagedIterable<GHRepository> listRepositories(int pageSize, RepositoryListFilter repoType) {
        return this.root.retrieve().with("type", repoType).asPagedIterable("/user/repos", GHRepository[].class, item -> item.wrap(this.root)).withPageSize(pageSize);
    }

    public PagedIterable<GHRepository> listAllRepositories() {
        return this.listRepositories();
    }

    public PagedIterable<GHMembership> listOrgMemberships() {
        return this.listOrgMemberships(null);
    }

    public PagedIterable<GHMembership> listOrgMemberships(GHMembership.State state) {
        return this.root.retrieve().with("state", state).asPagedIterable("/user/memberships/orgs", GHMembership[].class, item -> item.wrap(this.root));
    }

    public GHMembership getMembership(GHOrganization o) throws IOException {
        return ((GHMembership)((Object)this.root.retrieve().to("/user/memberships/orgs/" + o.getLogin(), GHMembership.class))).wrap(this.root);
    }

    public static enum RepositoryListFilter {
        ALL,
        OWNER,
        PUBLIC,
        PRIVATE,
        MEMBER;

    }
}

