/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.github.GHCreateRepositoryBuilder;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHEventInfo;
import org.kohsuke.github.GHHook;
import org.kohsuke.github.GHHooks;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPerson;
import org.kohsuke.github.GHProject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

public class GHOrganization
extends GHPerson {
    @Override
    GHOrganization wrapUp(GitHub root) {
        return (GHOrganization)super.wrapUp(root);
    }

    public GHRepository createRepository(String name, String description, String homepage, String team, boolean isPublic) throws IOException {
        GHTeam t = this.getTeams().get(team);
        if (t == null) {
            throw new IllegalArgumentException("No such team: " + team);
        }
        return this.createRepository(name, description, homepage, t, isPublic);
    }

    public GHRepository createRepository(String name, String description, String homepage, GHTeam team, boolean isPublic) throws IOException {
        if (team == null) {
            throw new IllegalArgumentException("Invalid team");
        }
        return this.createRepository(name).description(description).homepage(homepage).private_(!isPublic).team(team).create();
    }

    public GHCreateRepositoryBuilder createRepository(String name) {
        return new GHCreateRepositoryBuilder(this.root, "/orgs/" + this.login + "/repos", name);
    }

    public Map<String, GHTeam> getTeams() throws IOException {
        TreeMap<String, GHTeam> r = new TreeMap<String, GHTeam>();
        for (GHTeam t : this.listTeams()) {
            r.put(t.getName(), t);
        }
        return r;
    }

    public PagedIterable<GHTeam> listTeams() throws IOException {
        return this.root.retrieve().asPagedIterable(String.format("/orgs/%s/teams", this.login), GHTeam[].class, item -> item.wrapUp(this));
    }

    public GHTeam getTeamByName(String name) throws IOException {
        for (GHTeam t : this.listTeams()) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    public GHTeam getTeamBySlug(String slug) throws IOException {
        for (GHTeam t : this.listTeams()) {
            if (!t.getSlug().equals(slug)) continue;
            return t;
        }
        return null;
    }

    public void add(GHUser user, Role role) throws IOException {
        this.root.retrieve().method("PUT").with("role", role.name().toLowerCase()).to("/orgs/" + this.login + "/memberships/" + user.getLogin());
    }

    public boolean hasMember(GHUser user) {
        try {
            this.root.retrieve().to("/orgs/" + this.login + "/members/" + user.getLogin());
            return true;
        }
        catch (IOException ignore) {
            return false;
        }
    }

    public void remove(GHUser user) throws IOException {
        this.root.retrieve().method("DELETE").to("/orgs/" + this.login + "/members/" + user.getLogin());
    }

    public boolean hasPublicMember(GHUser user) {
        try {
            this.root.retrieve().to("/orgs/" + this.login + "/public_members/" + user.getLogin());
            return true;
        }
        catch (IOException ignore) {
            return false;
        }
    }

    public void publicize(GHUser u) throws IOException {
        this.root.retrieve().method("PUT").to("/orgs/" + this.login + "/public_members/" + u.getLogin(), null);
    }

    public List<GHUser> getMembers() throws IOException {
        return this.listMembers().asList();
    }

    public PagedIterable<GHUser> listMembers() throws IOException {
        return this.listMembers("members");
    }

    public PagedIterable<GHUser> listPublicMembers() throws IOException {
        return this.listMembers("public_members");
    }

    private PagedIterable<GHUser> listMembers(String suffix) throws IOException {
        return this.listMembers(suffix, null);
    }

    public PagedIterable<GHUser> listMembersWithFilter(String filter) throws IOException {
        return this.listMembers("members", filter);
    }

    private PagedIterable<GHUser> listMembers(String suffix, String filter) throws IOException {
        String filterParams = filter == null ? "" : "?filter=" + filter;
        return this.root.retrieve().asPagedIterable(String.format("/orgs/%s/%s%s", this.login, suffix, filterParams), GHUser[].class, item -> item.wrapUp(this.root));
    }

    public void conceal(GHUser u) throws IOException {
        this.root.retrieve().method("DELETE").to("/orgs/" + this.login + "/public_members/" + u.getLogin(), null);
    }

    public PagedIterable<GHProject> listProjects(GHProject.ProjectStateFilter status) throws IOException {
        return this.root.retrieve().withPreview("application/vnd.github.inertia-preview+json").with("state", status).asPagedIterable(String.format("/orgs/%s/projects", this.login), GHProject[].class, item -> item.wrap(this.root));
    }

    public PagedIterable<GHProject> listProjects() throws IOException {
        return this.listProjects(GHProject.ProjectStateFilter.OPEN);
    }

    public GHProject createProject(String name, String body) throws IOException {
        return ((GHProject)((Object)this.root.retrieve().method("POST").withPreview("application/vnd.github.inertia-preview+json").with("name", name).with("body", body).to(String.format("/orgs/%s/projects", this.login), GHProject.class))).wrap(this.root);
    }

    public GHTeam createTeam(String name, Permission p, Collection<GHRepository> repositories) throws IOException {
        Requester post = new Requester(this.root).with("name", name).with("permission", p);
        ArrayList<String> repo_names = new ArrayList<String>();
        for (GHRepository r : repositories) {
            repo_names.add(this.login + "/" + r.getName());
        }
        post.with("repo_names", repo_names);
        return ((GHTeam)((Object)post.method("POST").to("/orgs/" + this.login + "/teams", GHTeam.class))).wrapUp(this);
    }

    public GHTeam createTeam(String name, Permission p, GHRepository ... repositories) throws IOException {
        return this.createTeam(name, p, Arrays.asList(repositories));
    }

    public List<GHRepository> getRepositoriesWithOpenPullRequests() throws IOException {
        ArrayList<GHRepository> r = new ArrayList<GHRepository>();
        for (GHRepository repository : this.listRepositories(100)) {
            repository.wrap(this.root);
            List<GHPullRequest> pullRequests = repository.getPullRequests(GHIssueState.OPEN);
            if (pullRequests.size() <= 0) continue;
            r.add(repository);
        }
        return r;
    }

    public List<GHPullRequest> getPullRequests() throws IOException {
        ArrayList<GHPullRequest> all = new ArrayList<GHPullRequest>();
        for (GHRepository r : this.getRepositoriesWithOpenPullRequests()) {
            all.addAll(r.getPullRequests(GHIssueState.OPEN));
        }
        return all;
    }

    @Override
    public PagedIterable<GHEventInfo> listEvents() throws IOException {
        return this.root.retrieve().asPagedIterable(String.format("/orgs/%s/events", this.login), GHEventInfo[].class, item -> item.wrapUp(this.root));
    }

    @Override
    public PagedIterable<GHRepository> listRepositories(int pageSize) {
        return this.root.retrieve().asPagedIterable("/orgs/" + this.login + "/repos", GHRepository[].class, item -> item.wrap(this.root)).withPageSize(pageSize);
    }

    public List<GHHook> getHooks() throws IOException {
        return GHHooks.orgContext(this).getHooks();
    }

    public GHHook getHook(int id) throws IOException {
        return GHHooks.orgContext(this).getHook(id);
    }

    public GHHook createHook(String name, Map<String, String> config, Collection<GHEvent> events, boolean active) throws IOException {
        return GHHooks.orgContext(this).createHook(name, config, events, active);
    }

    public GHHook createWebHook(URL url, Collection<GHEvent> events) throws IOException {
        return this.createHook("web", Collections.singletonMap("url", url.toExternalForm()), events, true);
    }

    public GHHook createWebHook(URL url) throws IOException {
        return this.createWebHook(url, null);
    }

    public static enum Permission {
        ADMIN,
        PUSH,
        PULL;

    }

    public static enum Role {
        ADMIN,
        MEMBER;

    }
}

