/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHProject;
import org.kohsuke.github.GHProjectColumn;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Requester;

public class GHProjectCard
extends GHObject {
    private GitHub root;
    private GHProject project;
    private GHProjectColumn column;
    private String note;
    private GHUser creator;
    private String content_url;
    private String project_url;
    private String column_url;
    private boolean archived;

    @Override
    public URL getHtmlUrl() throws IOException {
        return null;
    }

    public GHProjectCard wrap(GitHub root) {
        this.root = root;
        return this;
    }

    public GHProjectCard wrap(GHProjectColumn column) {
        this.column = column;
        this.project = column.project;
        this.root = column.root;
        return this;
    }

    public GitHub getRoot() {
        return this.root;
    }

    public GHProject getProject() throws IOException {
        if (this.project == null) {
            try {
                this.project = ((GHProject)((Object)this.root.retrieve().to(this.getProjectUrl().getPath(), GHProject.class))).wrap(this.root);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return this.project;
    }

    public GHProjectColumn getColumn() throws IOException {
        if (this.column == null) {
            try {
                this.column = ((GHProjectColumn)((Object)this.root.retrieve().to(this.getColumnUrl().getPath(), GHProjectColumn.class))).wrap(this.root);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return this.column;
    }

    public GHIssue getContent() throws IOException {
        if (StringUtils.isEmpty((CharSequence)this.content_url)) {
            return null;
        }
        try {
            if (this.content_url.contains("/pulls")) {
                return ((GHPullRequest)((Object)this.root.retrieve().to(this.getContentUrl().getPath(), GHPullRequest.class))).wrap(this.root);
            }
            return ((GHIssue)((Object)this.root.retrieve().to(this.getContentUrl().getPath(), GHIssue.class))).wrap(this.root);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public String getNote() {
        return this.note;
    }

    public GHUser getCreator() {
        return this.creator;
    }

    public URL getContentUrl() {
        return GitHub.parseURL(this.content_url);
    }

    public URL getProjectUrl() {
        return GitHub.parseURL(this.project_url);
    }

    public URL getColumnUrl() {
        return GitHub.parseURL(this.column_url);
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setNote(String note) throws IOException {
        this.edit("note", note);
    }

    public void setArchived(boolean archived) throws IOException {
        this.edit("archived", archived);
    }

    private void edit(String key, Object value) throws IOException {
        new Requester(this.root).withPreview("application/vnd.github.inertia-preview+json")._with(key, value).method("PATCH").to(this.getApiRoute());
    }

    protected String getApiRoute() {
        return String.format("/projects/columns/cards/%d", this.id);
    }

    public void delete() throws IOException {
        new Requester(this.root).withPreview("application/vnd.github.inertia-preview+json").method("DELETE").to(this.getApiRoute());
    }
}

