/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github.extras.okhttp3;

import com.squareup.okhttp.CacheControl;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.extras.okhttp3.ObsoleteUrlFactory;

public class OkHttpConnector
implements HttpConnector {
    private static final String HEADER_NAME = "Cache-Control";
    private final String maxAgeHeaderValue;
    private final OkHttpClient client;
    private final ObsoleteUrlFactory urlFactory;

    public OkHttpConnector(OkHttpClient client) {
        this(client, 0);
    }

    public OkHttpConnector(OkHttpClient client, int cacheMaxAge) {
        OkHttpClient.Builder builder = client.newBuilder();
        builder.connectionSpecs(this.TlsConnectionSpecs());
        this.client = builder.build();
        this.maxAgeHeaderValue = cacheMaxAge >= 0 && this.client != null && this.client.cache() != null ? new CacheControl.Builder().maxAge(cacheMaxAge, TimeUnit.SECONDS).build().toString() : null;
        this.urlFactory = new ObsoleteUrlFactory(this.client);
    }

    @Override
    public HttpURLConnection connect(URL url) throws IOException {
        HttpURLConnection urlConnection = this.urlFactory.open(url);
        if (this.maxAgeHeaderValue != null) {
            urlConnection.setRequestProperty(HEADER_NAME, this.maxAgeHeaderValue);
        }
        return urlConnection;
    }

    private List<ConnectionSpec> TlsConnectionSpecs() {
        return Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.CLEARTEXT);
    }
}

